/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.test;

import java.math.BigDecimal;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Random;


/**
 * @author Yasuo Nakanishi
 */
public class TestDataUtility {

	private static final String INCLUSIVE = "abcdefghijklmnopqrstuvwxyzABCDEFHGIJKLMNOPQRSTUVWXYZ";
	private static final String EXCLUSIVE = "\\\"\r\n\t ";
    private static Random _rundom = new Random("blanco".hashCode());
    
    public static void reset() {
        _rundom = new Random("blanco".hashCode());
    }


	public static String getRandomString(int size) {
		StringBuffer sb = new StringBuffer();
        int maxSize = 0;
		char c = ' ';
        
        if(size > 1000) {
            maxSize = 1000;
        } else {
            maxSize = size;
        }
		
		while(sb.length() < maxSize){
			c = (char)('~' * _rundom.nextFloat() + 1);
			if(INCLUSIVE.indexOf(c) != -1 && EXCLUSIVE.indexOf(c) == -1){
				sb.append(c);
			}
		}
		return new String(sb);
	}

	public static int getRandomInt() {
		return	(int) (_rundom.nextInt());
	}

	public static long getRandomLong() {
		return	(long) (_rundom.nextLong());
	}

	public static float getRandomFloat() {
		return	(float) (_rundom.nextFloat());
	}

	public static long getRandomLongForDate() {
		long result = getRandomLong();
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		Date date = null;
		try {
			date =
				new Date(df.parse("9999-12-31").getTime());
		} catch (ParseException e) {
			e.printStackTrace();
		}
		while(date.before(new Date(result))){
			result = getRandomLong();
		}
        result = result / 10 * 10;
		return	result;
	}

	public static BigDecimal getRandomDecimal(int decimalPlace) {
		BigDecimal result = new BigDecimal(_rundom.nextDouble() * 10000000000l);
		return result.setScale(decimalPlace, BigDecimal.ROUND_UP);
	}

	public static BigDecimal getRandomDecimal(int size, int decimalPlace) {
	    BigDecimal max = null;
	    StringBuffer sb = new StringBuffer("1");
	    for(int i = 0; i < size - decimalPlace; i++) {
	        sb.append("0");
	    }
	    max = new BigDecimal(sb.toString());
		BigDecimal result = new BigDecimal(_rundom.nextDouble() * max.doubleValue());
		return result.setScale(decimalPlace, BigDecimal.ROUND_UP);
	}

	public static short getRandomShort() {
		return	(short) (_rundom.nextFloat() * Short.MAX_VALUE);
	}

	public static boolean getRandomBoolean() {
		return	_rundom.nextBoolean();
	}
    
    public static byte getRandomByte() {
        return  (byte) (getRandomFloat() * Byte.MAX_VALUE);
    }
    
    public static byte[] getRandomByteArray(int size) {
        byte[] result = null;
        int maxSize = size;
        
        if(maxSize > 1000) {
            maxSize = 1000;
        }
        result = new byte[maxSize];
        
        _rundom.nextBytes(result);
        return result;
    }
}
