/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.javadoc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.ig.expander.Type;


/**
 * @author Yasuo Nakanishi
 */
public class MethodJavaDoc extends JavaDoc {
    
    private String _return = "";
    private List _parameters = new ArrayList();
    private List _exceptions = new ArrayList();
	private boolean _deprecated = false;
    private String _deprecatedExposition = "";

	public MethodJavaDoc(){
	}
	
	public boolean isEmpty(){
        int size = _parameters.size() + _exceptions.size();
		return super.isEmpty() && size == 0 && _return.equals("");
	}

	public void addReturn(String doc) {
		StringBuffer sb = new StringBuffer();
		sb.append("@return ");
		sb.append(doc);
		_return = sb.toString();
	}

    public void addParameter(String name, String doc) {
        StringBuffer sb = new StringBuffer();
        sb.append("@param ");
        sb.append(name);
        sb.append(" ");
        sb.append(doc);
        _parameters.add(sb.toString());
    }

    public void addException(Type type, String doc) {
        StringBuffer sb = new StringBuffer();
        sb.append("@throw ");
        sb.append(type.getName());
        sb.append(" ");
        sb.append(doc);
        _exceptions.add(sb.toString());
    }

    public void expandJavaDoc() {
        if(!_parameters.isEmpty()) {
            addLine("");
            addLines(_parameters.iterator());
        }
        
        if(!_return.equals("")) {
            addLine("");
            addLine(_return);
        }

        if(!_exceptions.isEmpty()) {
            addLine("");
            addLines(_exceptions.iterator());
        }
		
		if(_deprecated) {
            addLine("@deprecated " + _deprecatedExposition);
		}
    }
    
    public void addLines(Iterator docs) {
        while(docs.hasNext()) {
            addLine((String) docs.next());
        }
    }
    
    public void setDeplicated(String exposition) {
        _deprecated = true;
        _deprecatedExposition = exposition;
    }
    
}
