/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.generator;

import java.io.IOException;

import blanco.ig.service.ServiceClass;

public abstract class AbstructGenerator implements Generator {
    private ServiceClass _serviceClass = null;
    
    protected AbstructGenerator(ServiceClass serviceClass) {
        _serviceClass = serviceClass;
    }
    
    protected ServiceClass getServiceClass() {
        return _serviceClass;
    }

    public final void generate() throws IOException {
        generateRuntime();
        generateDataStruct();
        generateMain();
        generateTest();
    }
    
}
