/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import blanco.core.datastruct.DataStructClass;
import blanco.core.datastruct.DataStructDefinition;
import blanco.ig.expander.Type;
import blanco.ig.service.ObjectClass;
import blanco.ig.service.ServiceClass;

/**
 * @author Yasuo Nakanishi
 */
public class MasterGenerator extends AbstructGenerator {
    private static MasterGenerator _instance = new MasterGenerator();

    private Map _dataStructDefinitions = new Hashtable();
    private Map _dataStructTypes = new Hashtable();
    private List _generatorList = new ArrayList();

    private MasterGenerator() {
        super(new ServiceClass("Master"));
    }
    
    public static MasterGenerator get() {
        return _instance;
    }
    
    public void regist(Generator generator) {
        _generatorList.add(generator);
    }

    public void addDataStruct(ObjectClass objectClass, DataStructClass expander) {
        String key = objectClass.getKey();
        _dataStructTypes.put(key, expander.getType());
    }
    
    public Type getDataStructType(ObjectClass objectClass) {
        assert _dataStructTypes.containsKey(objectClass.getKey());
        return (Type) _dataStructTypes.get(objectClass.getKey());
    }
    
    public DataStructDefinition getDataStructDefinition(ObjectClass objectClass) {
        assert _dataStructDefinitions.containsKey(objectClass.getKey());
        return (DataStructDefinition) _dataStructDefinitions.get(objectClass.getKey());
    }

    public void generateRuntime() throws IOException {
        Iterator i = _generatorList.iterator();
        Generator g = null;
        while(i.hasNext()) {
            g = (Generator) i.next();
            g.generateRuntime();
        }
    }

    public void generateDataStruct() throws IOException {
        Iterator i = _generatorList.iterator();
        Generator g = null;
        while(i.hasNext()) {
            g = (Generator) i.next();
            g.generateDataStruct();
        }
    }

    public void generateMain() throws IOException {
        Iterator i = _generatorList.iterator();
        Generator g = null;
        while(i.hasNext()) {
            g = (Generator) i.next();
            g.generateMain();
        }
    }

    public void generateTest() throws IOException {
        Iterator i = _generatorList.iterator();
        Generator g = null;
        while(i.hasNext()) {
            g = (Generator) i.next();
            g.generateTest();
        }
    }
}
