package blanco.plugin.strutsee.editors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import blanco.plugin.strutsee.BlancoStrutsEEPlugin;
import blanco.plugin.strutsee.actions.BlancoStrutsEEGenerateAction;

/**
 * blancoStrutsGfB^ <br>
 * 
 * @author iga
 */
public class BlancoStrutsEEEditor extends TextEditor {

    private Composite top = null;

    public static final String TARGET_FILENAME = "blancostruts.blancofw";

    public static final String BLANCO_META_FILE = "ʒ`t@C";

    public BlancoStrutsEEEditor() {
        // GR[fBO𑀍삷邽߂ɃZbgĂ܂B
        setDocumentProvider(new BlancoStrutsEEDocumentProvider());
    }

    public void createPartControl(Composite parent) {
        top = parent;
        top.setSize(new org.eclipse.swt.graphics.Point(1000, 400));

        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout(layout);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoStrutsTitle = new Label(top, SWT.NONE);
        labelBlancoStrutsTitle.setText("BlancoStrutsݒt@C GfB^");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoStrutsSettingId = new Label(top, SWT.NONE);
        labelBlancoStrutsSettingId.setText("ݒID");
        textBlancoStrutsSettingId = new Text(top, SWT.BORDER);
        textBlancoStrutsSettingId.setText("blancoStruts");
        textBlancoStrutsSettingId.setEditable(false);

        labelMetadir = new Label(top, SWT.NONE);
        labelMetadir.setText("^fBNg");
        createComboMetadir();

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelMetadirComment = new Label(top, SWT.NONE);
        labelMetadirComment.setText("^fBNg͒ʏύXɗp܂B");
        labelMetadirComment.setSize(new org.eclipse.swt.graphics.Point(500,
                30 + 20));

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonCreateMetafile = new Button(top, SWT.NONE);
        buttonCreateMetafile.setText(BLANCO_META_FILE + " VK쐬");
        buttonCreateMetafile
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        // ^t@C쐬̍ۂɂ́A̍ڂ̃`FbN͍s܂B
                        saveToTextEditor();

                        if (comboMetadir.getText().length() == 0) {
                            MessageDialog
                                    .openWarning(
                                            top.getShell(),
                                            BLANCO_META_FILE + " VK쐬",
                                            "^fBNgw肵ĂB\n"
                                                    + "^fBNg̈ʓIȐݒl 'meta/struts' łB");
                            return;
                        }

                        final IFileEditorInput input = (IFileEditorInput) getEditorInput();

                        try {
                            if (BlancoStrutsEEPluginUtil.findFolder(
                                    input.getFile(), getProgressMonitor(),
                                    comboMetadir.getText()).exists() == false) {
                                BlancoStrutsEEPluginUtil.createFolder(input
                                        .getFile(), getProgressMonitor(),
                                        comboMetadir.getText());

                                MessageDialog.openInformation(top.getShell(),
                                        "^fBNg̍쐬", "^fBNg ["
                                                + comboMetadir.getText()
                                                + "] VKɍ쐬܂B\n"
                                                + "ɂ̂ݕKvȓłB");
                            }
                        } catch (CoreException e3) {
                            MessageDialog.openWarning(top.getShell(),
                                    BLANCO_META_FILE + " VK쐬",
                                    "^fBNg쐬Ɏs܂Bf܂B:"
                                            + e3.toString());
                            e3.printStackTrace();
                            return;
                        }

                        try {
                            URL localURL = getPluginRoot();

                            InputDialog inputDialog = new InputDialog(top
                                    .getShell(), BLANCO_META_FILE + " VK쐬",
                                    BLANCO_META_FILE + "(^t@C)^fBNg["
                                            + comboMetadir.getText()
                                            + "]ɍ쐬܂B" + BLANCO_META_FILE
                                            + "̐VKt@C͂ĂB",
                                    "blancoStrutsMeta.xls",
                                    new IInputValidator() {
                                        public String isValid(String newText) {
                                            if (newText.endsWith(".xls") == false) {
                                                return "t@C .xlsŏI悤Ɏw肵ĂB";
                                            }
                                            if (newText.indexOf('/') >= 0
                                                    || newText.indexOf('\\') >= 0
                                                    || newText.indexOf(':') >= 0
                                                    || newText.indexOf(';') >= 0
                                                    || newText.indexOf('*') >= 0
                                                    || newText.indexOf('?') >= 0
                                                    || newText.indexOf('\"') >= 0
                                                    || newText.indexOf('>') >= 0
                                                    || newText.indexOf('<') >= 0
                                                    || newText.indexOf('|') >= 0) {
                                                return "t@Cɂ / \\ : ; * ? \" > < | ͗pȂłB";
                                            }
                                            // ɂ̃t@C݂Ȃǂ`FbN
                                            IFile newFileMeta = input.getFile()
                                                    .getProject().getFolder(
                                                            comboMetadir
                                                                    .getText())
                                                    .getFile(newText);
                                            if (newFileMeta.exists()) {
                                                return "w̃t@C͊ɑ݂Ă܂B"
                                                        + "ʂ̃t@Cw肵ĂB";
                                            }
                                            return null;
                                        }
                                    });
                            if (inputDialog.open() == InputDialog.CANCEL) {
                                inputDialog.close();
                                return;
                            }
                            final String newMetaFilename = inputDialog
                                    .getValue();
                            inputDialog.close();

                            // vOC̃[Jev[gǂݍ݂܂B
                            InputStream inStream = new FileInputStream(
                                    localURL.getPath()
                                            + "/meta/struts/template/blancoStrutsTemplate.xls");
                            IFile newFileMeta = input.getFile().getProject()
                                    .getFolder(comboMetadir.getText()).getFile(
                                            newMetaFilename);
                            newFileMeta.create(inStream, true,
                                    getProgressMonitor());
                            inStream.close();
                            MessageDialog.openInformation(top.getShell(),
                                    BLANCO_META_FILE + " VK쐬",
                                    BLANCO_META_FILE + "(^t@C ["
                                            + newMetaFilename + "] ^fBNg["
                                            + comboMetadir.getText()
                                            + "]ɐVK쐬܂B\n"
                                            + "̃t@CҏWāAʒ`֘Aݒ肵ĂB");
                        } catch (CoreException e1) {
                            e1.printStackTrace();
                            return;
                        } catch (IOException e2) {
                            MessageDialog.openWarning(top.getShell(), "^t@C",
                                    "^t@C̃Rs[Ɏs܂B:" + e2.toString());
                            e2.printStackTrace();
                        }

                    }
                });


		labelRuntimePakage = new Label(top, SWT.NONE);
		labelRuntimePakage.setText("^CpbP[W");

        createComboRuntimePakage();
		
        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelRuntimePakageComment = new Label(top, SWT.NONE);
		labelRuntimePakageComment.setText("^C\[X̃pbP[Ww肵ĉB");
		labelRuntimePakageComment.setSize(new org.eclipse.swt.graphics.Point(500, 20));

        // Xy[T[
        new Label(top, SWT.NONE).setText("");
		
		checkCreateRuntime = new Button(top, SWT.CHECK);
		checkCreateRuntime.setText("^C\[XR[ho͂B");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelRuntimePakageComment2 = new Label(top, SWT.NONE);
		labelRuntimePakageComment2.setText("x̓^C\[X𐶐ĂB");
		labelRuntimePakageComment2.setSize(new org.eclipse.swt.graphics.Point(500, 20));

        // Xy[T[
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
		
        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecute = new Button(top, SWT.NONE);
        buttonExecute.setText("\[XR[h");
        buttonExecute
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboMetadir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "\[XR[h", "^fBNg ("
                                                + comboMetadir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            showBusy(true);
                            // ēh~邽߂ɕKvłB
                            buttonExecute.setEnabled(false);

                            BlancoStrutsEEGenerateAction.processBlancoStruts(
                                    input.getFile(), top.getShell(),
                                    getProgressMonitor(), 
                                    comboMetadir.getText(),
                                    comboRuntimePakage.getText(),
                                    checkCreateRuntime.getSelection());

                            // blancotH_𓯊
                            BlancoStrutsEEPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(), "blanco");

                            // tmptH_𓯊
                            BlancoStrutsEEPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(), "tmp");

                            // strutstH_𓯊
                            // ܂łیƂē܂B
                            BlancoStrutsEEPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(),
                                    comboMetadir.getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(), "\[XR[h",
                                    "񕜕s\ȃG[.:" + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            showBusy(false);
                            // ēh~邽߂ɕKvłB
                            buttonExecute.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelSettingComment = new Label(top, SWT.NONE);
        labelSettingComment.setText("eX̐ݒl " + TARGET_FILENAME
                + "t@CɕŊi[܂B");
        labelSettingComment
                .setSize(new org.eclipse.swt.graphics.Point(500, 20));

        loadFromTextEditor();

        setFocusLostHandler(comboMetadir);
        setFocusLostHandler(comboRuntimePakage);
    }

    /**
     * vOC̃[gfBNg擾܂B
     * 
     * @return [gfBNgURL getPath()ƃtpXɂȂ܂B
     * @throws IOException
     */
    private URL getPluginRoot() throws IOException {
        URL relativeURL = BlancoStrutsEEPlugin.getDefault().getBundle()
                .getEntry("/");
        URL localURL = Platform.asLocalURL(relativeURL);
        return localURL;
    }

    private void setFocusLostHandler(Control target) {
        target.addFocusListener(new FocusListener() {
            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                saveToTextEditor();
            }

        });
    }

    public void setFocus() {
    }

    /**
     * Ǎs܂ <br>
     * ̃\bh͏ɖč쐬܂B <br>
     */
    public void loadFromTextEditor() {
        try {
            String editorText = getDocumentProvider().getDocument(
                    getEditorInput()).get();

            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(
                    new StreamSource(new StringReader(editorText)),
                    new SAXResult(new ContentHandler() {
                        public void setDocumentLocator(Locator arg0) {
                        }

                        public void startDocument() throws SAXException {
                        }

                        public void endDocument() throws SAXException {
                        }

                        public void startPrefixMapping(String arg0, String arg1)
                                throws SAXException {
                        }

                        public void endPrefixMapping(String arg0)
                                throws SAXException {
                        }

                        public void startElement(String arg0, String arg1,
                                String arg2, Attributes attributes)
                                throws SAXException {
                            // System.out.println("startElement:" + arg1);
                            if (arg1.equals("blancostruts")) {
                                // System.out.println("blancostrutsGeBeB𔭌");
                                for (int index = 0; index < attributes
                                        .getLength(); index++) {
                                    // System.out.println(attributes
                                    // .getLocalName(index));
                                    String localName = attributes
                                            .getLocalName(index);
                                    String value = attributes.getValue(index);
                                    if (localName.equals("metadir")) {
                                        comboMetadir.setText(value);
                                    }else if (localName.equals("runtimepakage")) {
                                        comboRuntimePakage.setText(value);
                                    }
                                }
                            }
                        }

                        public void endElement(String arg0, String arg1,
                                String arg2) throws SAXException {
                        }

                        public void characters(char[] arg0, int arg1, int arg2)
                                throws SAXException {
                        }

                        public void ignorableWhitespace(char[] arg0, int arg1,
                                int arg2) throws SAXException {
                        }

                        public void processingInstruction(String arg0,
                                String arg1) throws SAXException {
                        }

                        public void skippedEntity(String arg0)
                                throws SAXException {
                        }
                    }));
        } catch (TransformerConfigurationException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            // ̓ǂݍ݃G[͖܂B
        }
    }

    /**
     * ۑs܂B
     */
    public void saveToTextEditor() {
        StringWriter writer = new StringWriter();
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            SAXTransformerFactory saxTf = (SAXTransformerFactory) tf;
            TransformerHandler saxHandler;
            saxHandler = saxTf.newTransformerHandler();
            saxHandler.setResult(new StreamResult(writer));

            saxHandler.startDocument();
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "version", "version", "CDATA", "0.1.0");
            saxHandler.startElement("", "blanco", "blanco", attributes);
            attributes = new AttributesImpl();
            attributes.addAttribute("", "name", "name", "CDATA",
                    textBlancoStrutsSettingId.getText());
            saxHandler.startElement("", "target", "target", attributes);
            attributes = new AttributesImpl();

            attributes.addAttribute("", "metadir", "metadir", "CDATA",
                    comboMetadir.getText());
            attributes.addAttribute("", "runtimepakage", "runtimepakage", "CDATA",
                    comboRuntimePakage.getText());

            saxHandler.startElement("", "blancostruts", "blancostruts",
                    attributes);

            saxHandler.endElement("", "blancostruts", "blancostruts");
            saxHandler.endElement("", "target", "target");
            saxHandler.endElement("", "blanco", "blanco");

            saxHandler.endDocument();
        } catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        } catch (SAXException ex) {
            ex.printStackTrace();
        }

        String pastEditorText = getDocumentProvider().getDocument(
                getEditorInput()).get();
        if (pastEditorText.equals(writer.toString()) == false) {
            // eقȂꍇɂ̂ݏ݂s܂B
            getDocumentProvider().getDocument(getEditorInput()).set(
                    writer.toString());
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    /**
     * ͍ڂ̃`FbN{܂B <br>
     * G[_CAO͂̃\bhŕ\܂B
     * 
     * @return
     */
    private final boolean checkInputField() {
        boolean isError = false;
        if (comboMetadir.getText().length() == 0) {
            comboMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (comboRuntimePakage.getText().length() == 0) {
			comboRuntimePakage.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
			comboRuntimePakage.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }
		
        if (isError) {
            MessageDialog.openWarning(top.getShell(), "K{ڂւ̓͂܂",
                    "K{ڂւ̓͂܂B\nnCCg\ĂK{ڂɒl͂Ă");
        }

        return !isError;
    }

    // rWÄ
    private Label labelBlancoStrutsTitle = null;

    private Label labelBlancoStrutsSettingId = null;

    private Text textBlancoStrutsSettingId = null;

    private Label labelMetadir = null;

    private Combo comboMetadir = null;

    private Label labelMetadirComment = null;

    private Label labelSettingComment = null;

    private Button buttonExecute = null;

    private Button buttonCreateMetafile = null;

	
    private Label labelRuntimePakage = null;
    
	private Label labelRuntimePakageComment = null;

	private Label labelRuntimePakageComment2 = null;

	private Combo comboRuntimePakage = null;

    private Button checkCreateRuntime = null;
	
	
    /**
     * This method initializes comboMetadir
     * 
     */
    private void createComboMetadir() {
        comboMetadir = new Combo(top, SWT.NONE);
        comboMetadir.add("meta/struts");
        comboMetadir.select(0);
    }

	private void createComboRuntimePakage() {
		comboRuntimePakage = new Combo(top, SWT.NONE);
		comboRuntimePakage.add("root.pkg");
		comboRuntimePakage.select(0);
    }
}