/*
 * blancoCommons Copyright (C) 2005 Yoshinori WATANABE
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */

package blanco.commons.sql.format;

/**
 * BlancoSqlFormatter: SQL`c[. SQL߂ꂽ[ɏ]`܂B <br>
 * SQLƂĐƂOłB
 * http://homepage2.nifty.com/igat/igapyon/diary/2005/ig050613.html <br>
 * g[N킵܂B
 * 
 * @author Yoshinori WATANABE (a-san) : original version at 2005.07.04.
 * @author Tosiki Iga : marge into blanc Framework at 2005.07.04
 */
class BlancoSqlToken {
    /**
     * 󕶎. TAB,CRP̕ƂĊ܂ށB
     */
    static final int SPACE = 0;

    /**
     * L. " <="̂悤ȂQłP̋LB
     */
    static final int SYMBOL = 1;

    /**
     * L[[h. "SELECT", "ORDER"Ȃ.
     */
    static final int KEYWORD = 2;

    /**
     * O. e[uA񖼂ȂǁB_uNH[e[VtꍇB
     */
    static final int NAME = 3;

    /**
     * l. liAjAȂǁB
     */
    static final int VALUE = 4;

    /**
     * Rg. VOCRgƃ}`CRgB
     */
    static final int COMMENT = 5;

    /**
     * SQL̏I.
     */
    static final int END = 6;

    /**
     * ͕s\ȃg[N. ʏSQLł͂肦ȂB
     */
    static final int UNKNOWN = 7;

    /**
     * g[Nʂ̕. fobOŎgp.
     */
    static final String[] TYPE_STRING = { "SPACE  ", "SYMBOL ", "KEYWORD",
            "NAME   ", "VALUE  ", "COMMENT", "END    ", "???????" };

    /** g[N. */
    int type;

    /** g[N. */
    String s;

    /** g[N쐬. */
    BlancoSqlToken(int type, String s) {
        this.type = type;
        this.s = s;
    }

    /** g[Nʂ𕶎ŕԂ. */
    String getTypeString() {
        return TYPE_STRING[type];
    }

    /** g[N𕶎ŕԂ. */
    public String toString() {
        String s1 = BlancoSqlUtil.replace(s, "\n", "\\n");
        String s2 = BlancoSqlUtil.replace(s1, "\t", "\\t");
        return TYPE_STRING[type] + "[" + s2 + "]";
    }
}
