/*
 * blancoSOAP Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.wsdl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoXmlUtil;
import blanco.sax.util.BlancoSaxUtil;
import blanco.wsdl.concretesax.BlancoWsdlXml2XsdOutputSerializer;

/**
 * blancoWsdl: XMLXSD쐬܂B<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoWsdlXml2Xsd {
    /**
     * Kw`\L[[hłB
     */
    private static final String HIERARCHY = "hierarchy";

    public static void main(String[] args) {
        try {
            new BlancoWsdlXml2Xsd().process(new File("./tmp/telegram/aaa.xml"),
                    new File("tmp/telegram/wsdl"));
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void process(File fileSource, File directoryTarget)
            throws IOException, SAXException, TransformerException {
        DOMResult result = new DOMResult();
        InputStream inStream = null;
        try {
            inStream = new FileInputStream(fileSource);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inStream), result);
        } finally {
            if (inStream != null) {
                inStream.close();
                inStream = null;
            }
        }

        Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            Document rootDocument = (Document) rootNode;
            NodeList listSheet = rootDocument.getElementsByTagName("sheet");
            int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);

                NodeList listCommon = elementSheet
                        .getElementsByTagName("common");
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                Element elementCommon = (Element) listCommon.item(0);

                final String telemgramId = BlancoXmlUtil.getTextContent(
                        elementCommon, "telegramId");
                if (telemgramId == null) {
                    continue;
                }

                final String telegramType = BlancoXmlUtil.getTextContent(
                        elementCommon, "telegramType");
                if (telegramType == null) {
                    continue;
                }

                expandSheet(elementSheet, elementCommon, directoryTarget);
            }
        }
    }

    private static String toClassName(final String path, final String name) {
        if (path == null) {
            return name;
        } else {
            return BlancoSaxUtil.toClassName(path + "/" + name);
        }
    }

    static void expandSheet(final Element elementSheet,
            final Element elementCommon, final File directoryTarget)
            throws IOException, SAXException, TransformerConfigurationException {
        final String telegramId = BlancoXmlUtil.getTextContent(elementCommon,
                "telegramId");
        final String telegramType = BlancoXmlUtil.getTextContent(elementCommon,
                "telegramType");
        final String telegramNamespace = BlancoXmlUtil.getTextContent(
                elementCommon, "telegramNamespace");

        NodeList listTelegramList = elementSheet
                .getElementsByTagName("telegramList");
        // dɂẮAdꗗ󗓂łƂĂs܂B
        // ̂߁AlistTelegramList̒`FbN͍s܂B

        OutputStream outStream = null;
        try {
            directoryTarget.mkdirs();
            outStream = new FileOutputStream(directoryTarget.getAbsolutePath()
                    + "/" + telegramId + ".xsd");

            BlancoWsdlXml2XsdOutputSerializer serializer = new BlancoWsdlXml2XsdOutputSerializer(
                    outStream);
            serializer.startDocument();
            serializer.startElementXsdSchema(telegramNamespace,
                    telegramNamespace, "http://www.w3.org/2001/XMLSchema");

            // pẌꗗ擾܂B
            LinkedHashMap pathList = new LinkedHashMap();
            // ő[̃pXL܂B
            int maxPathDeapth = 0;

            NodeList listTelegram = ((Element) listTelegramList.item(0))
                    .getElementsByTagName("telegram");
            int sizeListRow = listTelegram.getLength();

            // dvF`ɂ͓ɋLڂȂƂA[g(:root)
            // Öق̂(邢̓ftHg)݂pXłB
            // ̂߁AŃ}bvɑ΂ĖIɓo^{܂B
            pathList.put("", "root");

            // ŏɃpẌꗗmKv̂ŁApXr߂܂B
            for (int indexField = 0; indexField < sizeListRow; indexField++) {
                final Element elementTelegram = (Element) listTelegram
                        .item(indexField);

                String fieldPath = BlancoXmlUtil.getTextContent(
                        elementTelegram, "fieldPath");
                // ŃpẌꗗL܂B
                pathList.put(fieldPath, fieldPath);
                maxPathDeapth = Math.max(splitPath(fieldPath).length,
                        maxPathDeapth);
            }

            serializer.characters("\n");

            // Vv^`stB[ḧꗗێ܂B
            LinkedHashMap simpleTypeList = new LinkedHashMap();

            // Vv^`KvǂfAKvɉĒ`{܂B
            for (int indexField = 0; indexField < sizeListRow; indexField++) {
                final Element elementTelegram = (Element) listTelegram
                        .item(indexField);

                final String minLength = BlancoXmlUtil.getTextContent(
                        elementTelegram, "minLength");
                final String maxLength = BlancoXmlUtil.getTextContent(
                        elementTelegram, "maxLength");
                final String minInclusive = BlancoXmlUtil.getTextContent(
                        elementTelegram, "minInclusive");
                final String maxInclusive = BlancoXmlUtil.getTextContent(
                        elementTelegram, "maxInclusive");
                final String pattern = BlancoXmlUtil.getTextContent(
                        elementTelegram, "pattern");
                if (minLength != null || maxLength != null
                        || minInclusive != null || maxInclusive != null
                        || pattern != null) {
                    // ŏEő咷EŏlEőlEp^[ɂẮA
                    // Vv^`̎{KvɂȂ܂B
                    final String fieldName = BlancoXmlUtil.getTextContent(
                            elementTelegram, "fieldName");
                    final String fieldPath = BlancoXmlUtil.getTextContent(
                            elementTelegram, "fieldPath");

                    expandSimpleType(elementTelegram, serializer);
                    simpleTypeList.put(toClassName(fieldPath, fieldName),
                            "^`ς");
                }
            }

            final HashMap processedPath = new HashMap();
            for (int pathDeapth = maxPathDeapth; pathDeapth >= 0; pathDeapth--) {
                // SĂ̊KwɂāA[̋tŏs܂B
                for (Iterator iterator = pathList.keySet().iterator(); iterator
                        .hasNext();) {
                    String fieldPath = (String) iterator.next();
                    if (fieldPath == null) {
                        fieldPath = "";
                    }
                    // Kw̐[vꍇɂ̂ݏs܂B
                    if (pathDeapth != splitPath(fieldPath).length) {
                        continue;
                    }

                    if (processedPath.get(fieldPath) != null) {
                        // ɏspXłBXLbv܂B
                        continue;
                    }
                    processedPath.put(fieldPath, fieldPath);
                    expandPath(telegramId, telegramType, simpleTypeList,
                            listTelegramList, serializer, fieldPath);
                }
            }
            serializer.endElementXsdSchema();
            serializer.endDocument();
            outStream.flush();
        } finally {
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    /**
     * Vv^`𑕔܂B
     * 
     * @param elementTelegram
     * @param serializer
     * @throws SAXException
     */
    private static void expandSimpleType(final Element elementTelegram,
            BlancoWsdlXml2XsdOutputSerializer serializer) throws SAXException {
        final String fieldName = BlancoXmlUtil.getTextContent(elementTelegram,
                "fieldName");
        final String fieldType = BlancoXmlUtil.getTextContent(elementTelegram,
                "fieldType");
        final String minLength = BlancoXmlUtil.getTextContent(elementTelegram,
                "minLength");
        final String maxLength = BlancoXmlUtil.getTextContent(elementTelegram,
                "maxLength");
        final String minInclusive = BlancoXmlUtil.getTextContent(
                elementTelegram, "minInclusive");
        final String maxInclusive = BlancoXmlUtil.getTextContent(
                elementTelegram, "maxInclusive");
        final String pattern = BlancoXmlUtil.getTextContent(elementTelegram,
                "pattern");
        final String fieldPath = BlancoXmlUtil.getTextContent(elementTelegram,
                "fieldPath");

        serializer.characters("  ");
        serializer.startElementXsdSimpleType(toClassName(fieldPath, fieldName));
        serializer.characters("\n");
        serializer.characters("    ");
        serializer.startElementXsdRestriction(fieldType);
        serializer.characters("\n");

        if (minLength != null && maxLength != null
                && minLength.equals(maxLength)) {
            serializer.characters("      ");
            serializer.startElementXsdLength(minLength, "true");
            serializer.endElementXsdLength();
            serializer.characters("\n");
        } else {
            if (minLength != null) {
                serializer.characters("      ");
                serializer.startElementXsdMinLength(minLength);
                serializer.endElementXsdMinLength();
                serializer.characters("\n");
            }
            if (maxLength != null) {
                serializer.characters("      ");
                serializer.startElementXsdMaxLength(maxLength);
                serializer.endElementXsdMaxLength();
                serializer.characters("\n");
            }
        }

        if (minInclusive != null) {
            serializer.characters("      ");
            serializer.startElementXsdMinInclusive(minInclusive);
            serializer.endElementXsdMinInclusive();
            serializer.characters("\n");
        }
        if (maxInclusive != null) {
            serializer.characters("      ");
            serializer.startElementXsdMaxInclusive(maxInclusive);
            serializer.endElementXsdMaxInclusive();
            serializer.characters("\n");
        }
        if (pattern != null) {
            serializer.characters("      ");
            serializer.startElementXsdPattern(pattern);
            serializer.endElementXsdPattern();
            serializer.characters("\n");
        }

        serializer.characters("    ");
        serializer.endElementXsdRestriction();
        serializer.characters("\n");
        serializer.characters("  ");
        serializer.endElementXsdSimpleType();
        serializer.characters("\n");
    }

    /**
     * w肳ꂽPath (XPath) ɂēWJs܂B
     * 
     * @param telegramId
     * @param telegramType
     * @param listTelegramList
     * @param serializer
     * @param targetFieldPath
     *            null͗^ȂłB
     * @throws SAXException
     */
    private static void expandPath(String telegramId, String telegramType,
            LinkedHashMap simpleTypeList, NodeList listTelegramList,
            BlancoWsdlXml2XsdOutputSerializer serializer, String targetFieldPath)
            throws SAXException {
        System.out.println("pX[" + targetFieldPath + "]");

        serializer.characters("\n  ");
        if (targetFieldPath == null) {
            serializer.startElementXsdComplexType(telegramId);
        } else {
            serializer.startElementXsdComplexType(getComplexTypeName(
                    telegramId, targetFieldPath));
        }

        serializer.characters("\n    ");
        serializer.startElementXsdSequence();

        NodeList listTelegram = ((Element) listTelegramList.item(0))
                .getElementsByTagName("telegram");
        int sizeListRow = listTelegram.getLength();
        for (int indexField = 0; indexField < sizeListRow; indexField++) {
            final Element elementTelegram = (Element) listTelegram
                    .item(indexField);

            final String no = BlancoXmlUtil.getTextContent(elementTelegram,
                    "no");
            final String fieldName = BlancoXmlUtil.getTextContent(
                    elementTelegram, "fieldName");
            final String fieldType = BlancoXmlUtil.getTextContent(
                    elementTelegram, "fieldType");
            String fieldPath = BlancoXmlUtil.getTextContent(elementTelegram,
                    "fieldPath");
            if (fieldPath == null) {
                // nullƈ̂ 󔒂Zbg܂B
                fieldPath = "";
            }
            final String minOccurs = BlancoXmlUtil.getTextContent(
                    elementTelegram, "minOccurs");
            final String maxOccurs = BlancoXmlUtil.getTextContent(
                    elementTelegram, "maxOccurs");

            if (fieldName == null && fieldType == null) {
                // K{ڂĖݒ̏ꍇɂ͍sǂݔ΂܂B
                continue;
            }
            if (fieldName != null && fieldType == null) {
                throw new IllegalArgumentException("dID[" + telegramId + "]"
                        + (no == null ? "" : " ڔԍ[" + no + "]") + " ږ["
                        + fieldName + "] ̌^ݒłB");
            }
            if (fieldName == null && fieldType != null) {
                throw new IllegalArgumentException("dID[" + telegramId + "]"
                        + (no == null ? "" : " ڔԍ[" + no + "]") + " ^["
                        + fieldType + "] ̍ږݒłB");
            }

            if (fieldPath.equals(targetFieldPath) == false) {
                // pXقȂĂ܂B̕Kv͂܂B
                // ȂA̔rɂ悤ɁAnull͒lƂēĂȂƂƉ肵܂B
                continue;
            }

            // Kw`ł̂ŁÂ悤ɏs܂B
            if (fieldType.equals(HIERARCHY)) {
                serializer.characters("\n ");
                serializer.startElementXsdElement(fieldName, "tns:"
                        + getComplexTypeName(telegramId,
                                (fieldPath == null ? "" : fieldPath) + "/"
                                        + fieldName), minOccurs, maxOccurs);
                serializer.endElementXsdElement();
                continue;
            }

            serializer.characters("\n      ");
            if (simpleTypeList.get(toClassName(fieldPath, fieldName)) == null) {
                serializer.startElementXsdElement(fieldName, fieldType,
                        minOccurs, maxOccurs);
            } else {
                // Vv^`ς݂Ȃ̂ŁAQƂ悤ɂ܂B
                serializer.startElementXsdElement(fieldName, "tns:"
                        + toClassName(fieldPath, fieldName), minOccurs,
                        maxOccurs);
            }
            serializer.endElementXsdElement();
        }

        serializer.characters("\n    ");
        serializer.endElementXsdSequence();
        serializer.characters("\n  ");
        serializer.endElementXsdComplexType();
        serializer.characters("\n");
    }

    /**
     * ^ꂽdIDƃpXƂɕ^̖̂擾܂B
     * 
     * @param telegramId
     * @param targetFieldPath
     * @return
     */
    static final String getComplexTypeName(final String telegramId,
            String targetFieldPath) {
        String pathName = "";
        for (StringTokenizer token = new StringTokenizer(targetFieldPath, "/"); token
                .hasMoreTokens();) {
            String next = token.nextToken();
            if (next == null) {
                break;
            }
            if (next.length() > 2) {
                next = Character.toUpperCase(next.charAt(0))
                        + next.substring(1);
            }
            pathName += next;
        }
        return telegramId + pathName;

    }

    /**
     * ^ꂽXPathpX𕪉܂B<br>
     * null^ꂽꍇA0ƕ͂܂B
     * 
     * @param arg
     * @return
     */
    static final String[] splitPath(String arg) {
        if (arg == null) {
            return new String[0];
        }
        ArrayList result = new ArrayList();
        for (StringTokenizer token = new StringTokenizer(arg, "/"); token
                .hasMoreTokens();) {
            String next = token.nextToken();
            if (next == null) {
                break;
            }
            result.add(next);
        }
        return (String[]) result.toArray(new String[result.size()]);
    }
}