/*
 * blancoSOAP Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.xsd;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.valueobject.concretesax.BlancoValueObjectSerializer;
import blanco.xsd.parser.BlancoXsdParser;
import blanco.xsd.parser.ComplexTypeFieldStructure;
import blanco.xsd.parser.ComplexTypeStructure;
import blanco.xsd.parser.SimpleTypeStructure;

/**
 * blancoWsdl: XSDValueObjectXML쐬܂B<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoXsdXsd2ValueObject {

    public static void main(String[] args) {
        try {
            new BlancoXsdXsd2ValueObject().process(new File(
                    "./tmp/telegram/wsdl/TAAA0001Input.xsd"), new File(
                    "tmp/telegram/wsdl"));
        } catch (IOException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        } catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void process(final File fileSource, final File directoryTarget)
            throws IOException, TransformerException, SAXException {
        // xsdp[X܂B
        BlancoXsdParser parser = new BlancoXsdParser();
        if (fileSource.getName().endsWith(".xsd") == false) {
            // ӁF.xsdŃt@C͏IƉ肵Ă܂B
            throw new IllegalArgumentException("t@C.xsdŏÎw肵ĂB:"
                    + fileSource.getName());
        }
        final ComplexTypeStructure type = parser.process(fileSource.getName()
                .substring(0, fileSource.getName().length() - 4), fileSource);
        expandComplexType(type, directoryTarget);
    }

    private void expandComplexType(final ComplexTypeStructure type,
            final File directoryTarget) throws SAXException, IOException,
            TransformerConfigurationException {
        OutputStream outStream = null;
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(
                    directoryTarget.getAbsolutePath() + "/" + type.getName()
                            + ".blancovalueobject"));
            BlancoValueObjectSerializer serializer = new BlancoValueObjectSerializer(
                    outStream);
            serializer.startDocument();
            serializer.startElementBlanco("0.1.0");
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.startElementTarget("blancoValueObject");
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementBlancovalueobject(type.getName(), type
                    .getPackageOfJava());
            serializer.characters("\n");
            serializer.characters("      ");
            serializer.startElementFile();
            serializer.characters("\n");
            serializer.characters("        ");
            serializer.startElementComment();
            serializer.characters("̃t@CxsdꂽNXłB");
            serializer.endElementComment();
            serializer.characters("\n");
            serializer.characters("      ");
            serializer.endElementFile();
            serializer.characters("\n");
            serializer.characters("      ");
            serializer.startElementClass();
            serializer.characters("\n");
            serializer.characters("        ");
            serializer.startElementJavadoc();
            serializer.characters("̃NXxsdJavaNXłB");
            serializer.endElementJavadoc();
            serializer.characters("\n");
            serializer.characters("      ");
            serializer.endElementClass();
            serializer.characters("\n");
            serializer.characters("\n");

            for (int index = 0; index < type.getListField().size(); index++) {
                ComplexTypeFieldStructure field = (ComplexTypeFieldStructure) type
                        .getListField().get(index);

                if (field.getTypeStructure() instanceof ComplexTypeStructure) {
                    expandComplexType((ComplexTypeStructure) field
                            .getTypeStructure(), directoryTarget);
                }

                serializer.characters("      ");
                if (field.getMaxOccurs() != null
                        && field.getMaxOccurs().equals("1") == false) {
                    // ̏ꍇɂ͔z񈵂܂B
                    serializer.startElementField(field.getFieldName(), field
                            .getTypeStructure().getTypeOfJava()
                            + "[]");
                } else {
                    serializer.startElementField(field.getFieldName(), field
                            .getTypeStructure().getTypeOfJava());
                }
                serializer.characters("\n");
                serializer.characters("        ");
                serializer.startElementJavadoc();
                serializer.characters("tB[h[" + field.getFieldName() + "]łB");
                serializer.endElementJavadoc();
                serializer.characters("\n");

                if (field.getTypeStructure() instanceof SimpleTypeStructure) {
                    SimpleTypeStructure simpleType = (SimpleTypeStructure) field
                            .getTypeStructure();
                    if (simpleType.getMinLength() != null) {
                        serializer.startElementMinLength();
                        serializer.characters(simpleType.getMinLength());
                        serializer.endElementMinLength();
                    }

                    if (simpleType.getMaxLength() != null) {
                        serializer.startElementMaxLength();
                        serializer.characters(simpleType.getMaxLength());
                        serializer.endElementMaxLength();
                    }

                    if (simpleType.getMinInclusive() != null) {
                        serializer.startElementMinInclusive();
                        serializer.characters(simpleType.getMinInclusive());
                        serializer.endElementMinInclusive();
                    }

                    if (simpleType.getMaxInclusive() != null) {
                        serializer.startElementMaxInclusive();
                        serializer.characters(simpleType.getMaxInclusive());
                        serializer.endElementMaxInclusive();
                    }

                    if (simpleType.getPattern() != null) {
                        serializer.startElementPattern();
                        serializer.characters(simpleType.getPattern());
                        serializer.endElementPattern();
                    }
                }
                serializer.characters("      ");
                serializer.endElementField();
                serializer.characters("\n");
            }
            serializer.characters("    ");
            serializer.endElementBlancovalueobject();
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.endElementTarget();
            serializer.characters("\n");
            serializer.endElementBlanco();
            serializer.endDocument();
            outStream.flush();
            outStream.close();
            outStream = null;
        } finally {
            if (outStream != null) {
                outStream.close();
            }
        }
    }
}