/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct;

import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class WriteAccessor extends MethodExpander {
	private Value _value = null;

	public WriteAccessor(Value value) {
		super(createName(value));
		_value = value;
	}

    public void setupSignature() {
        setReturnType(new Type(void.class));
        addArgument(getArgumentValue(_value));

        String doc = "";
        String name = getNameAdjuster().toValueName(_value.getName());
        getJavaDoc().addLine(name + " ݒB");
        getJavaDoc().addParameter(name, _value.getName() + " p[^B");
    }
    
    private Value getArgumentValue(Value value) {
        String name = getNameAdjuster().toValueName(value.getName());
        return new Value(value.getType(), name);
    }

    public static String createName(Value value) {
	    return createName(value.getName());
	}

	public static String createName(String baseName) {
	    return MethodExpander.createName("set", baseName);
	}

	public void implement() {
	    NameAdjuster nt = getNameAdjuster();

	    Implementor i = new Implementor(getData());
		Value fieldValue = getField(_value.getName());
        
		i.assign(fieldValue, new Statement(getArgumentValue(_value)));
	}
}
