package blanco.plugin.strutsee.editors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.StorageDocumentProvider;

public class BlancoStrutsEEDocumentProvider extends
        StorageDocumentProvider {

    /**
     * hLg̓ǂݍݏI[o[Ch܂B
     */
    protected void setDocumentContent(IDocument document,
            InputStream contentStream, String encodingIgnored)
            throws CoreException {
        // GR[fBO͖ċI UTF-8Ƃ܂B
        super.setDocumentContent(document, contentStream, "UTF-8");
    }

    /**
     * hLg̕ۑI[o[Ch܂B
     */
    protected void doSaveDocument(IProgressMonitor monitor, Object element,
            IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof IFileEditorInput) {
            // ̏ꏊŕۑs܂B
            IFileEditorInput input = (IFileEditorInput) element;
            String editorText = getDocument(input).get();

            try {
                input.getFile().setContents(
                        new ByteArrayInputStream(editorText.getBytes("UTF-8")),
                        true, false, monitor);
            } catch (UnsupportedEncodingException e) {
                // ȂƂ 肦Ȃ͂łB
                e.printStackTrace();
            }
        }
    }
}