package blanco.plugin.strutsee.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

import blanco.plugin.strutsee.editors.BlancoStrutsEEEditor;

public class BlancoStrutsEEWizard extends Wizard implements INewWizard {
    private ISelection selection;

    public BlancoStrutsEEWizard() {
        super();
        setNeedsProgressMonitor(true);
        setWindowTitle("blancoStruts Enterprise Edition Wizard");
    }

    public void addPages() {
        addPage(new BlancoStrutsEEWizardPage(selection));
        addPage(new BlancoStrutsEEWizardPage2(selection));
        addPage(new BlancoStrutsEEWizardPage3(selection));
        addPage(new BlancoStrutsEEWizardPage4(selection));
        addPage(new BlancoStrutsEEWizardPage99(selection));
    }

    public boolean performFinish() {
        // {IɃ`FbN̓EBU[hŏIĂƉ肵܂B
        IProject proj = getProject(selection);
        if (proj == null) {
            return false;
        }

        //  t@CVK쐬܂B
        IFile file = proj.getFile(BlancoStrutsEEEditor.TARGET_FILENAME);
        doFinish(file);

        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        try {
            // blancoStrutsGfB^J܂B
            IDE.openEditor(page, file, "blanco.plugin.strutsee.editors");
        } catch (PartInitException e) {
        }

        return true;
    }

    /**
     * ISelection IProject(vWFNg)擾܂B
     */
    public static final IProject getProject(ISelection selection) {
        IProject proj = null;
        IStructuredSelection ssel = (IStructuredSelection) selection;
        if (ssel.isEmpty()) {
            return null;
        }
        Object obj = ssel.getFirstElement();
        if (obj instanceof IProjectNature) {
            // vWFNg̏ꍇɂ́AꂪĂ܂B
            IProjectNature nature = (IProjectNature) obj;
            proj = nature.getProject();
        } else if (obj instanceof IResource) {
            IResource res = (IResource) obj;
            proj = res.getProject();
        } else {
            System.out.println(obj.getClass());
            return null;
        }
        return proj;
    }

    // ǂđgݍ݂܂B
    private void doFinish(IFile file) {
        try {
            InputStream stream = openContentStream();
            if (file.exists()) {
                // Ȃɂ܂B
            } else {
                file.create(stream, false, null);
            }
            stream.close();
        } catch (IOException e) {
        } catch (CoreException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    private InputStream openContentStream() {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><blanco/>";
        return new ByteArrayInputStream(contents.getBytes());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}