/*
 * blancoStruts Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.struts;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.ig.collector.ResourceBundleLoader;
import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Type;
import blanco.ig.generator.ImplementGenerator;
import blanco.ig.generator.RuntimeGenerator;
import blanco.ig.service.ServiceClass;
import blanco.struts.action.AbstractBaseAction;
import blanco.struts.action.AbstractDbAction;
import blanco.struts.definition.form.FieldValidation;
import blanco.struts.definition.form.Form;
import blanco.struts.definition.form.FormEvent;
import blanco.struts.definition.form.FormField;
import blanco.struts.definition.form.FormTable;
import blanco.struts.definition.form.SizeValidationType;
import blanco.struts.exception.BlancoStrutsValidateException;
import blanco.struts.exception.BusinessException;
import blanco.struts.exception.ValidateException;
import blanco.struts.expander.action.AbstractActionClass;
import blanco.struts.expander.form.ActionFormClass;
import blanco.struts.expander.form.TableItemClass;
import blanco.struts.generator.StrutsSetting;
import blanco.struts.metadata.StrutsMetadata;
import blanco.struts.runtime.validator.Validator;
import blanco.struts.runtime.validator.message.ErrorMessageKey;
import blanco.struts.util.BlancoStrutsExpandUtil;

public class BlancoStrutsXml2JavaClass {

    public static void main(String[] args) {
        new BlancoStrutsXml2JavaClass().process(
                new File("./tmp/struts/aaa.xml"), new File("blanco"), "myapp", true);
        System.out.println("SĂ̏");
    }

    private StrutsSetting setting;

    private StrutsMetadata metadata;

    private HashMap mapTable = new HashMap();

    private HashMap mapFieldEvent = new HashMap();

    public void process(final File fileSource, final File directoryTarget,
            final String rootPackage, final boolean isCreateRuntime) {
        DOMResult result = new DOMResult();
        InputStream inStream = null;
        try {
            inStream = new FileInputStream(fileSource);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inStream), result);
        } catch (TransformerConfigurationException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } finally {
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        setting = new StrutsSetting();
        // main͌ŒlƂ܂B
        setting.setMainOutputDirectory("main");
        setting.setRootNameSpace(rootPackage);
        setting.setWorkDirectory(directoryTarget.getAbsolutePath());

        Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            Document rootDocument = (Document) rootNode;
            NodeList listSheet = rootDocument.getElementsByTagName("sheet");
            int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);
                System.out.println("V[g[" + elementSheet.getAttribute("name")
                        + "]");

                NodeList listCommon = elementSheet
                        .getElementsByTagName("common");
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                NodeList listActionFormSetting = elementSheet
                        .getElementsByTagName("actionFormSetting");
                if (listActionFormSetting.getLength() == 0) {
                    continue;
                }

                NodeList listActionSetting = elementSheet
                        .getElementsByTagName("actionSetting");
                if (listActionSetting.getLength() == 0) {
                    continue;
                }

                NodeList listFieldList = elementSheet
                        .getElementsByTagName("fieldList");
                if (listFieldList.getLength() == 0) {
                    continue;
                }

                Element elementCommon = (Element) listCommon.item(0);
                if (BlancoStrutsExpandUtil.readStringByElementTagName(
                        elementCommon, "screenId") == null) {
                    continue;
                }
                Element elementActionFormSetting = (Element) listActionFormSetting
                        .item(0);
                Element elementActionSetting = (Element) listActionSetting
                        .item(0);
                Element elementFieldList = (Element) listFieldList.item(0);
                try {
                    expandSheet(elementSheet, elementCommon,
                            elementActionFormSetting, elementActionSetting,
                            elementFieldList, setting);
                } catch (SecurityException e) {
                    e.printStackTrace();
                } catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }

		if(isCreateRuntime){
	        RuntimeGenerator rg = new RuntimeGenerator(setting);
	
	        rg.addSourceDirectory("src/main");
	        rg.addRuntime(ResourceBundleLoader.class);
	        rg.addRuntime(Validator.class);
	        rg.addRuntime(ErrorMessageKey.class);
	
	        String target = "";
	        target = setting.getRootNameSpace() + ".runtime";
	        if (target.equals(".runtime")) {
	            target = "blanco.struts.runtime";
	        }
	        rg.addPackagePair("blanco.struts.runtime", target);
	        rg.addPackagePair("blanco.ig.collector", target);
	        try {
	            rg.generate();
	        } catch (IOException e) {
	            e.printStackTrace();
	        }
	
	        RuntimeGenerator rgT = new RuntimeGenerator(setting);
			rgT.addSourceDirectory("src/main");
			rgT.addRuntime(AbstractBaseAction.class);
			rgT.addRuntime(AbstractDbAction.class);
	
	        String targetT = "";
			targetT = setting.getRootNameSpace() + ".action";
			rgT.addPackagePair("blanco.struts.action", targetT);
			rgT.addPackagePair("blanco.struts.exception", setting.getRootNameSpace() + ".exception");
	        try {
				rgT.generate();
	        } catch (IOException e) {
	            e.printStackTrace();
	        }
	
	        RuntimeGenerator rgE = new RuntimeGenerator(setting);
			rgE.addSourceDirectory("src/main");
			rgE.addRuntime(BlancoStrutsValidateException.class);
			rgE.addRuntime(BusinessException.class);
			rgE.addRuntime(ValidateException.class);
	
	        String targetE = "";
			targetE = setting.getRootNameSpace() + ".exception";
			rgE.addPackagePair("blanco.struts.exception", targetE);
	        try {
				rgE.generate();
	        } catch (IOException e) {
	            e.printStackTrace();
	        }
		}

	}

    private String screenId;

    private String actionFormPackageName;

    void expandSheet(final Element elementSheet, final Element elementCommon,
            final Element elementActionFormSetting,
            final Element elementActionSetting, final Element elementFieldList,
            final StrutsSetting setting) throws SecurityException,
            NoSuchMethodException {
        screenId = BlancoStrutsExpandUtil.readStringByElementTagName(
                elementCommon, "screenId");
        actionFormPackageName = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementActionFormSetting,
                        "packageName");
        final String screenName = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementCommon, "screenName");
        final String actionPackageName = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementActionSetting, "packageName");
        final String screenAutoValidation = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementCommon,
                        "screenAutoValidation");
        final String screenUseDatabase = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementCommon, "screenUseDatabase");
        final String saveToken = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementActionSetting, "saveToken");

        Form form = new Form(actionFormPackageName, screenId + "Form");
        form.setFormClassName((screenName == null ? screenId : screenName + "("
                + screenId + ")")
                + "̃ANVtH[NXłB<br>");
        form.setFormClassOutLine("of[VȂǂ̏܂B");
        // jf[VɂāAtrue/false]Ă_ɒӁB
        form.setAutoValidation(screenAutoValidation == null
                || screenAutoValidation.equals("false") ? true : false);
        form.setEnebledJavaDoc(true);
        form
                .setSaveToken(saveToken == null || saveToken.equals("false") ? false
                        : true);
        form.setUsingDb(screenUseDatabase == null
                | screenUseDatabase.equals("false") ? false : true);

        metadata = new StrutsMetadata();

        // Cxg̐U蕪Ɏgpp[^B
        // Tv̒ʂȂ炢Ȃ悤ɂĂB
        metadata.setEventParameterName("eventId");

        ImplementGenerator ig = new ImplementGenerator(new ServiceClass(
                "Struts"), setting);

        NodeList listField = elementFieldList.getElementsByTagName("field");
        for (int index = 0; index < listField.getLength(); index++) {
            final Element elementField = (Element) listField.item(index);
            final String fieldName = BlancoStrutsExpandUtil
                    .readStringByElementTagName(elementField, "name");
            if (fieldName == null) {
                continue;
            }

            final String description = BlancoStrutsExpandUtil
                    .readStringByElementTagName(elementField, "description");

            final String isSubmit = BlancoStrutsExpandUtil
                    .readStringByElementTagName(elementField, "isSubmit");
            if (isSubmit != null && isSubmit.equals("true")) {
                // \bh
                final String nameLocal = BlancoStrutsExpandUtil
                        .readStringByElementTagName(elementField, "nameLocal");
                final String isCheckToken = BlancoStrutsExpandUtil
                        .readStringByElementTagName(elementField,
                                "isCheckToken");

                FormEvent event = new FormEvent(fieldName);
                if (description != null) {
                    event.setDescription(description);
                }
                if (nameLocal != null) {
                    event.setKoumokuNihongoMei(nameLocal);
                }
                if (isCheckToken != null && isCheckToken.equals("true")) {
                    // TokenmF
                    event.setCheckToken(true);
                }
                form.addEvent(event);
                Type type = new Type(actionPackageName, "Abstract"
                        + new NameAdjuster().toClassName(screenId) + "Action");
                AbstractActionClass abstractActionClass = new AbstractActionClass(
                        type, metadata, form, setting);
                abstractActionClass.getJavaDoc().addLine(
                        "ʒ`ID[" + screenId + "]̒ۃANVNX");
                // eNXZbg܂B
                // TODO ̎w͊O̕Kv肻łB
                ig.addMain(abstractActionClass);
            } else {
                // ̓tB[hB
                expandField(ig, elementField, form);
            }
        }

        for (Iterator ite = mapTable.values().iterator(); ite.hasNext();) {
            FormTable formTable = (FormTable) ite.next();
            ig.addMain(new TableItemClass(formTable.getType(), formTable));
        }

        for (Iterator ite = form.getEventIterator(); ite.hasNext();) {
            FormEvent formEvent = (FormEvent) ite.next();
            ArrayList list = (ArrayList) mapFieldEvent.get(formEvent.getName());
            // TODO `FbNs߂ɂ́AmapFieldEvent}bv邪pȂ̂G[ƂĈׂ
            if (list == null) {
                // {^͂̂AɊ֘A`FbN͖ꍇɂʉ߂܂B
                // nłI
                continue;
            }
            for (int index = 0; index < list.size(); index++) {
                FormField field = (FormField) list.get(index);
                formEvent.addValidationField(field);
            }
        }

        try {
            ig.addMain(new ActionFormClass(setting, metadata, form));
            ig.generate();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * tB[hWJ܂B
     */
    private void expandField(final ImplementGenerator ig,
            final Element elementField, final Form form) {

        final String fieldName = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField, "name");
        final String fieldDescription = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField, "description");
        final String fieldTypeOnUI = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField, "typeOnUI");
        String fieldType = BlancoStrutsExpandUtil.readStringByElementTagName(
                elementField, "type");
        final String minLength = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField, "minLength");
        final String maxLength = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField, "maxLength");
        final String lengthValidationType = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField,
                        "lengthValidationType");

        final String format = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField, "format");
        final String minRange = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField, "minRange");
        final String maxRange = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField, "maxRange");
        final String fielddefault = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField, "default");
        final String regex = BlancoStrutsExpandUtil.readStringByElementTagName(
                elementField, "regex");
        // `FbNځB
        final String checkExecute = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField, "checkExecute");
        final String isCheckRequire = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField, "isCheckRequire");
        final String regexMessageKey = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField, "regexMessageKey");

        if (fieldType == null) {
            // قƂ͂ŃG[B
            return;
        }

        // System.out.println("fieldName:" + fieldName);
	
        if (fieldTypeOnUI.equals("Label")) {
			// Labelł́Ajava.lang.String^̂݃T|[gB
	        if (!fieldType.equals("java.lang.String")) {
	            throw new IllegalArgumentException(
	                    "Labelł̓T|[gȂ^łBjava.lang.String w肵ĂB" + " ʒ`ID["
	                            + screenId + "] tB[h[" + fieldName + "] ^["
	                            + fieldType + "]");
	        }
        }
		
        if (fieldTypeOnUI.equals("DropdownList")) {
			// DropdownListł́Ajava.util.Collection^̂݃T|[gB
	        if (!fieldType.equals("java.util.Collection")) {
	            throw new IllegalArgumentException(
	                    "DropdownListł̓T|[gȂ^łBjava.util.Collection w肵ĂB" + " ʒ`ID["
	                            + screenId + "] tB[h[" + fieldName + "] ^["
	                            + fieldType + "]");
	        }
			
            // ƂblancoStrutsɉLƓ̃R[fBO݁B
            fieldType = "java.lang.String";
        }

        FormField formField = new FormField(new Type(fieldType), fieldName);

        final String tableGroup = BlancoStrutsExpandUtil
                .readStringByElementTagName(elementField, "tableGroup");
        if (tableGroup == null) {
            form.addField(formField);
        } else {
            Object objTableExist = mapTable.get(tableGroup);
            if (objTableExist == null) {
                mapTable.put(tableGroup, new FormTable(screenId,
                        actionFormPackageName, tableGroup, 0));
            }
            FormTable formTable = (FormTable) mapTable.get(tableGroup);
            formTable.addField(formField);
            form.addTable(formTable);
        }

        if (fieldDescription != null) {
            // ڂ̐ JavaDocɗp
            formField.setDescription(fieldDescription);
        }

        // ڌ^
        formField.setUiType(fieldTypeOnUI);

        // u^v̓RXgN^Œ񋟍ς݁B

        FieldValidation validation = new FieldValidation();
        formField.setValidation(validation);

        // MINAMAX
        if (minLength != null || maxLength != null) {
            if (!fieldType.equals("java.lang.String")) {
                throw new IllegalArgumentException(
                        "`FbNT|[gȂ^łB`FbN̎w폜ĂB" + " ʒ`ID["
                                + screenId + "] tB[h[" + fieldName + "] ^["
                                + fieldType + "]");
            }

            validation.setCheckSize(true);
            if (minLength != null) {
                validation.setMinSize(minLength);
            }
            if (maxLength != null) {
                validation.setMaxSize(maxLength);
            }
            if (lengthValidationType == null
                    || lengthValidationType.equals("byteCount")) {
                validation.setSizeValidationType(SizeValidationType.BYTES);
            } else {
                validation.setSizeValidationType(SizeValidationType.LENGTH);
            }
        }

        // Kl
        if (fielddefault != null) {
            formField.setDefault(fielddefault);
        } else if (fieldType.equals("java.lang.String")) {
            formField.setDefault("");
        }

        // `FbN
        // TODO sB
        if (checkExecute != null) {
            for (StringTokenizer token = new StringTokenizer(checkExecute,
                    " ,\\."); token.hasMoreElements();) {
                String verb = token.nextToken();
                if (mapFieldEvent.get(verb) == null) {
                    mapFieldEvent.put(verb, new ArrayList());
                }
                ArrayList list = (ArrayList) mapFieldEvent.get(verb);
                list.add(formField);
            }
        }

        // K{
        if (isCheckRequire != null && isCheckRequire.equals("true")) {
            // System.out.println("K{");
            validation.setCheckRequire(true);
        }

        // `^Cv
        if (format != null && format.equals("Ȃ") == false) {
            validation.setCheckFormat(true);
            validation.setFormat(format);
        }

        // K\
        if (regex != null) {
            validation.setCheckRegex(true);
            validation.setRegex(regex);
            if (regexMessageKey != null) {
                validation.setRegexMessageKey(regexMessageKey);
            }
        }

        // ͈Validate (l)
        if (minRange != null || maxRange != null) {
            if (!fieldType.equals("int")) {
                throw new IllegalArgumentException(
                        "͈̓`FbNT|[gȂ^łB͈̓`FbN̎w폜ĂB" + " ʒ`ID["
                                + screenId + "] tB[h[" + fieldName + "] ^["
                                + fieldType + "]");
            }

            validation.setCheckRange(true);
            if (minRange != null) {
                validation.setMinRange(minRange);
            }
            if (maxRange != null) {
                validation.setMaxRange(maxRange);
            }
        }
    }
}
