/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.struts.definition.form;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import blanco.core.datastruct.DataStructDefinition;
import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class Form extends DataStructDefinition {

    private Type _type = null;

    private boolean _autoValidation = true;

    private List _eventList = new ArrayList();

    private Map _eventMap = new Hashtable();

    private Map _tableMap = new Hashtable();

    private static NameAdjuster _adjuster = new NameAdjuster();

    private Type _actionType = null;

    private boolean _usingDb = false;

    private String _formClassName = "";

    private String _formClassOutLine = "";

    private String _actionClassName = "";

    private String _actionClassOutLine = "";

    private boolean _isSaveToken = false;

    public String getActionClassName() {
        return _actionClassName;
    }

    public void setActionClassName(String actionClassName) {
        _actionClassName = actionClassName;
    }

    public Form(String nameSpace, String className) {
        super(_adjuster.toClassName(className));
        _type = new Type(nameSpace, getName());
    }

    public boolean isAutoValidation() {
        return _autoValidation;
    }

    public void addField(FormField field) {
        super.addField(field);

        Iterator i = field.getEventIterator();
        String eventName = "";
        while (i.hasNext()) {
            eventName = (String) i.next();
            if (!_autoValidation) {
                FormEvent event = (FormEvent) _eventMap.get(eventName);
                if (event == null) {
                    String message = "sȃCxgn܂BCxg:";
                    message += eventName;
                    throw new RuntimeException(message);
                }
                event.addValidationField(field);
            }
        }
    }

    public void addEvent(FormEvent event) {
        _eventList.add(event);
        setupEventMap(event);
    }

    private void setupEventMap(FormEvent event) {
        if (!_eventMap.containsKey(event.getName())) {
            _eventMap.put(event.getName(), event);
        }
    }

    public void setAutoValidation(boolean autoValidation) {
        _autoValidation = autoValidation;
    }

    public Type getType() {
        return _type;
    }

    public Iterator getEventIterator() {
        return _eventList.iterator();
    }

    public void setActionType(String nameSpace, String name) {
        _actionType = new Type(nameSpace, name);
    }

    public Type getActionType() {
        return _actionType;
    }

    public Iterator getEventFieldIterator(String eventName) {
        FormEvent event = (FormEvent) _eventMap.get(eventName);
        return event.getValidationFieldIterator();
    }

    public void addTable(FormTable table) {
        _tableMap.put(table.getName(), table);
    }

    public Iterator getTableIterator() {
        return _tableMap.values().iterator();
    }

    public boolean hasTalble(String name) {
        return _tableMap.containsKey(name);
    }

    public FormTable getTable(String name) {
        return (FormTable) _tableMap.get(name);
    }

    public boolean isUsingDb() {
        return _usingDb;
    }

    public void setUsingDb(boolean usingDb) {
        _usingDb = usingDb;
    }

    public String getFormClassName() {
        return _formClassName;
    }

    public void setFormClassName(String className) {
        _formClassName = className;
    }

    public String getFormClassOutLine() {
        return _formClassOutLine;
    }

    public void setFormClassOutLine(String classOutline) {
        _formClassOutLine = classOutline;
    }

    public String getActionClassOutLine() {
        return _actionClassOutLine;
    }

    public void setActionClassOutLine(String actinoClassOutLine) {
        _actionClassOutLine = actinoClassOutLine;
    }

    /**
     * @return _isSaveToken ߂܂B
     */
    public boolean isSaveToken() {
        return _isSaveToken;
    }

    /**
     * @param saveToken
     *            _isSaveToken ݒB
     */
    public void setSaveToken(boolean saveToken) {
        _isSaveToken = saveToken;
    }
}
