/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.struts.definition.form;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import blanco.core.datastruct.DataStructDefinition;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class FormTable extends DataStructDefinition {
    private String _guiId = "";

    private String _nameSpace = "";

    private Map _eventMap = new Hashtable();

    private int _tableClassNamePrefixSizeByGuiId = 0;

    private String _id = "";

    public FormTable(String guiId, String nameSpace, String name,
            int tableClassNamePrefixSizeByGuiId) {
        super(name);
        _guiId = guiId;
        _nameSpace = nameSpace;
        _tableClassNamePrefixSizeByGuiId = tableClassNamePrefixSizeByGuiId;

        String prefix = _guiId;
        if (_tableClassNamePrefixSizeByGuiId > 0
                && _guiId.length() > _tableClassNamePrefixSizeByGuiId) {
            prefix = _guiId.substring(0, _tableClassNamePrefixSizeByGuiId);
        }
        _id = prefix + getName();
    }

    public String getId() {
        return _id;
    }

    public Type getType() {

        return new Type(_nameSpace, getId());
    }

    public void addField(FormField field) {
        super.addField(field);

        Iterator i = field.getEventIterator();
        String event = "";
        while (i.hasNext()) {
            event = (String) i.next();
            setupEventMap(event);
            List list = (List) _eventMap.get(event);
            list.add(field);
        }
    }

    public boolean existFormValidationField() {
        boolean result = false;

        Iterator i = getFieldIterator();
        FormField f = null;
        FieldValidation fv = null;
        while (i.hasNext()) {
            f = (FormField) i.next();
            fv = f.getValidation();
            if (fv.isCheckFormat() || fv.isCheckSize() || fv.isCheckRange()
                    || fv.isCheckRegex()) {
                result = true;
            }
        }
        return result;
    }

    public boolean existEventFormValidationField(String event) {
        boolean result = false;

        Iterator i = getFieldIterator();
        FormField f = null;
        FieldValidation fv = null;
        Iterator eventIterator = null;
        boolean existsEvent = false;

        while (i.hasNext()) {
            f = (FormField) i.next();
            fv = f.getValidation();

            eventIterator = f.getEventIterator();
            while (eventIterator.hasNext()) {
                if (eventIterator.next().equals(event)) {
                    existsEvent = true;
                    break;
                }
            }

            if (existsEvent
                    && (fv.isCheckFormat() || fv.isCheckSize()
                            || fv.isCheckRange() || fv.isCheckRegex())) {
                result = true;
            }
            existsEvent = false;

        }
        return result;
    }

    public boolean existRequireValidationField() {
        boolean result = false;

        Iterator i = getFieldIterator();
        FormField f = null;
        FieldValidation fv = null;
        Iterator events = null;

        while (i.hasNext()) {
            f = (FormField) i.next();
            fv = f.getValidation();
            if (fv.isCheckRequire()) {
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean existEventRequireValidationField(String event) {
        boolean result = false;

        Iterator i = getFieldIterator();
        FormField f = null;
        FieldValidation fv = null;
        Iterator events = null;
        boolean existEvent = false;

        while (i.hasNext()) {
            f = (FormField) i.next();
            fv = f.getValidation();

            events = f.getEventIterator();
            while (events.hasNext()) {
                if (events.next().equals(event)) {
                    existEvent = true;
                    break;
                }
            }
            if (existEvent && fv.isCheckRequire()) {
                result = true;
                break;
            }
            existEvent = false;
        }
        return result;
    }

    public boolean existEventField(String event) {
        setupEventMap(event);
        List list = (List) _eventMap.get(event);
        return list.size() != 0;
    }

    public Iterator getEventFieldIterator(String event) {
        setupEventMap(event);
        List list = (List) _eventMap.get(event);
        return list.iterator();
    }

    private void setupEventMap(String event) {
        if (!_eventMap.containsKey(event)) {
            _eventMap.put(event, new ArrayList());
        }
    }

}
