/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.struts.expander.action;

import java.util.Iterator;

import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.struts.definition.form.Form;
import blanco.struts.definition.form.FormEvent;
import blanco.struts.generator.StrutsSetting;
import blanco.struts.metadata.StrutsMetadata;

/**
 * @author Yasuo Nakanishi
 */
public class AbstractActionClass extends ClassExpander {
    // private Method _dispatchMethod = null;

    private String _eventParameterName = "";

    private StrutsMetadata _metadata = null;

    private Form _form = null;
	
	private StrutsSetting _setting = null;

    public AbstractActionClass(Type type, StrutsMetadata metadata, Form form, final StrutsSetting setting)
            throws SecurityException, NoSuchMethodException {
        super(type);
        _eventParameterName = metadata.getEventParameterName();
        _form = form;
        _metadata = metadata;
		_setting = setting;
    }

    protected void expandClassStruct() {

        Type formType = _form.getType();

        String target = "";
        target = _setting.getRootNameSpace() + ".action";
        if (target.equals(".action")) {
            target = "blanco.struts.action";
        }
		
        if (!_form.isUsingDb()) {
            setSuperClass(new Type(target + ".AbstractBaseAction"));
	        addMethod(new DispatchMethod("executeAction", _metadata
	                .getEventParameterName(), formType, _form));
        } else {
            setSuperClass(new Type(target + ".AbstractDbAction"));
	        addMethod(new DispatchMethod("executeDbAction", _metadata
	                .getEventParameterName(), formType, _form));
        }

        FormEvent event = null;

        event = new FormEvent("init", "");
        addMethod(new EventMethod(event, formType, _form));

        event = new FormEvent("load", "[h");
        addMethod(new EventMethod(event, formType, _form));

        Iterator i = _form.getEventIterator();
        while (i.hasNext()) {
            event = (FormEvent) i.next();
            addMethod(new EventMethod(event, formType, _form));

            if (event.isCheckToken()) {
                addMethod(new FoundInvalidTokenMethod(event, formType, _form));
            }
        }

        // 2005.05.26 t.iga ǉ\bh̕Kv΁AŒǉ

        getJavaDoc().addLine("blancoStrutsActionNX<br>");
        getJavaDoc().addLine("̃NXorg.apache.struts.action.ActioncɎ܂");

        String doc = "";
        doc = _form.getActionClassName() + "B";
        getJavaDoc().addLine(doc);

        doc = _form.getActionClassOutLine();
        getJavaDoc().addLine(doc);
    }

    protected final boolean isAbstract() {
        return true;
    }

}
