/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.struts.definition.form;

import java.util.Iterator;

import junit.framework.TestCase;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class ActionFormDefinitionTest extends TestCase {

    public static String toString(Form target) {
        StringBuffer sb = new StringBuffer();
        sb.append("Type:[");
        sb.append(toString(target.getType()));
        sb.append("], AutoValidation:");
        sb.append(target.isAutoValidation());
        sb.append(", Fields:[");
        sb.append(toStringFields(target.getFieldIterator()));
        sb.append("]");
        return sb.toString();
    }

    public static String toStringFields(Iterator fields) {
        StringBuffer sb = new StringBuffer();
        FormField f = null;

        if (fields.hasNext()) {
            f = (FormField) fields.next();
            sb.append(", [");
            sb.append(FormFieldTest.toString(f));
            sb.append("]");
        }

        while (fields.hasNext()) {
            f = (FormField) fields.next();
            sb.append(", [");
            sb.append(FormFieldTest.toString(f));
            sb.append("]");
        }
        return sb.toString();
    }

    public static String toString(Type target) {
        StringBuffer sb = new StringBuffer();
        sb.append("NameSpace:");
        if (!target.isPrimitive()) {
            sb.append(target.getNameSpace());
        }
        sb.append(", Name:");
        sb.append(target.getName());
        sb.append(", Array:");
        sb.append(target.isArray());
        return sb.toString();
    }

    public void testAccessor() {
        Form target = create();

        String expect = "";

        expect += "Type:[" + toString(target.getType()) + "]";
        expect += ", AutoValidation:true";
        expect += ", Fields:[";
        expect += toStringFields(target.getFieldIterator());
        expect += ("]");

        assertEquals(expect, toString(target));
    }

    public static Form create() {
        Form result = new Form("struts.form", "Form");
        result.addField(FormFieldTest.create());
        return result;
    }
}
