/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.struts.definition.form;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import junit.framework.TestCase;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class FormFieldTest extends TestCase {

    public static String toString(FormField target) {
        StringBuffer sb = new StringBuffer();
        sb.append("Name:");
        sb.append(target.getValue().getName());
        sb.append(", Type:[");
        sb.append(toString(target.getValue().getType()));
        sb.append("], Description:");
        sb.append(target.getName());
        return sb.toString();
    }

    public static String toString(Type target) {
        StringBuffer sb = new StringBuffer();
        sb.append("NameSpace:");
        if (!target.isPrimitive()) {
            sb.append(target.getNameSpace());
        }
        sb.append(", Name:");
        sb.append(target.getName());
        sb.append(", Array:");
        sb.append(target.isArray());
        return sb.toString();
    }

    public void testAccessor() {
        FormField target = create();

        String expect = "";
        expect += "Name:Form";
        expect += ", Type:[" + toString(new Type(String.class)) + "]";
        expect += ", Description:";

        assertEquals(expect, toString(target));
    }

    public static FormField create() {
        Type type = new Type(String.class);
        FormField result = new FormField(type, "Form");
        result.addEvent("hoge");
        result.setValidation(FieldValidationTest.create());
        return result;
    }

    public static Iterator createAllTypes() {
        List result = new ArrayList();
        result.add(createString());
        result.add(createInt());
        return result.iterator();
    }

    public static FormField createString() {
        Type type = new Type(String.class);
        FormField result = new FormField(type, "string");
        result.addEvent("hoge");
        result.setValidation(FieldValidationTest.create());
        return result;
    }

    public static FormField createInt() {
        Type type = new Type(int.class);
        FormField result = new FormField(type, "integer");
        result.addEvent("hoge");
        result.setValidation(FieldValidationTest.create());
        return result;
    }

    public static FormField createRequireOn() {
        return createRequireOn("requireOn");
    }

    public static FormField createRequireOn(String name) {
        Type type = new Type(String.class);
        FormField result = new FormField(type, name);
        result.addEvent("hoge");
        result.setValidation(FieldValidationTest.createRequireOn());
        return result;
    }

    public static FormField createRequireOff() {
        Type type = new Type(String.class);
        FormField result = new FormField(type, "requireOff");
        result.addEvent("hoge");
        result.setValidation(FieldValidationTest.createRequireOff());
        return result;
    }

    public static FormField createEvent1() {
        FormField result = createRequireOn("Event1");
        result.addEvent("Action1");
        return result;
    }

    public static FormField createEvent2() {
        FormField result = createRequireOn("Event2");
        result.addEvent("Action2");
        return result;
    }

    public static FormField createEvent3() {
        FormField result = createRequireOn("Event3");
        result.addEvent("Action3");
        return result;
    }

    public static FormField createEvent123() {
        FormField result = createRequireOn("Event123");
        result.addEvent("Action1");
        result.addEvent("Action2");
        result.addEvent("Action3");
        return result;
    }

    public static FormField createEvent13() {
        FormField result = createRequireOn("Event13");
        result.addEvent("Action1");
        result.addEvent("Action3");
        return result;
    }

    public static Iterator createEventIterator() {
        List result = new ArrayList();
        result.add(createEvent1());
        result.add(createEvent2());
        result.add(createEvent3());
        result.add(createEvent13());
        result.add(createEvent123());
        return result.iterator();
    }
}
