/*
 * blancoCodeGenerator
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgInterface;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.javadoc.ClassJavaDoc;
import blanco.ig.expander.method.MethodExpander;
import blanco.ig.generator.GeneratorSetting;
import blanco.ig.generator.ImplementGenerator;

/**
 * blancoCodeGenerator̃NXǂNXB
 * 
 * @author Yasuo Nakanishi (1st version)
 * @author IGA Tosiki (2nd version)
 */
public abstract class ClassExpander extends Expander {
    /**
     * blanco Framework̃IuWFNgt@NgB
     */
    private final BlancoCgObjectFactory fCgFactory = BlancoCgObjectFactory
            .getInstance();

    /**
     * blancoCgClass\B
     */
    private BlancoCgClass fCgClass = null;

    /**
     * blancoCgInterface\B
     */
    private BlancoCgInterface fCgInterface = null;

    /**
     * blancoCodeGeneratorIɕێ \[Xt@C̃RgB
     */
    private final ArrayList fSourceFileComment = new ArrayList();

    /**
     * blancoCodeGeneratorƂēIɕێ importListB
     */
    private final ArrayList fImportList = new ArrayList();

    /**
     * blancoCodeGeneratorIɕێ JavaDocB
     */
    private final ClassJavaDoc fJavaDoc = new ClassJavaDoc();

    /**
     * blancoCodeGeneratorIɕێ FieldꗗB
     */
    private final ArrayList fFieldList = new ArrayList();

    /**
     * blancoCodeGeneratorIɕێ MethodꗗB
     */
    private final ArrayList fMethodList = new ArrayList();

    /**
     * blancoCodeGeneratorIɕێ ̃NX̂̂̌^B
     */
    private Type fType = null;

    /**
     * blancoCodeGeneratorClassExpander𐶐܂B
     * 
     * @param argType
     *            blancoCodeGeneratorƂĂ̌^B
     */
    public ClassExpander(final Type argType) {
        fType = argType;

        if (isInterface() == false) {
            fCgClass = fCgFactory.createClass(BlancoNameUtil
                    .trimJavaPackage(argType.getFullName()), "");
            fCgClass.setAccess(getScope().get());
            fCgClass.setAbstract(isAbstract());
            fCgClass.setFinal(isFinal());

            if (BlancoStringUtil.null2Blank(fType.getGenerics()).length() > 0) {
                // WFlNXڑ܂B
                fCgClass.setGenerics(fType.getGenerics());
            }
        } else {
            fCgInterface = fCgFactory.createInterface(BlancoNameUtil
                    .trimJavaPackage(argType.getFullName()), "");
            fCgInterface.setAccess(getScope().get());

            if (BlancoStringUtil.null2Blank(fType.getGenerics()).length() > 0) {
                // WFlNXڑ܂B
                fCgInterface.setGenerics(fType.getGenerics());
            }
        }
    }

    /**
     * C^tF[Xǂ킷\bhB
     * 
     * @return ftHg false (NX) l߂܂B
     */
    protected boolean isInterface() {
        return false;
    }

    /**
     * ̃NXC^tF[Xǉ܂B
     * 
     * @param argType
     *            t^B
     */
    public final void addInterface(final Type argType) {
        if (fCgClass == null) {
            throw new IllegalArgumentException("C^tF[Xɑ΂ăC^tF[X["
                    + argType.getFullName() + "]ǉ悤Ƃ܂B");
        }
        fCgClass.getImplementInterfaceList().add(
                fCgFactory.createType(argType.getFullName()));
    }

    /**
     * NX̍\WJ܂B
     * 
     * ̃\bhI[o[ChāAۂ̃NX\Lq܂B
     */
    protected abstract void expandClassStruct();

    /**
     * C|[g̈ꗗ擾܂B
     * 
     * @return
     */
    public final ArrayList getImportList() {
        return fImportList;
    }

    /**
     * \[XR[hɓWJ邽߂̃\bhB
     */
    public final void expand() {
        expandClassStruct();

        // NXWJB
        // blancoCodeGeneratorJavaDoc blancoCgւƈڑ܂B
        for (int index = 0; index < fJavaDoc.getList().size(); index++) {
            final Object objLook = fJavaDoc.getList().get(index);
            if (objLook instanceof String) {
                if (fCgClass != null) {
                    fCgClass.getLangDoc().getDescriptionList().add(
                            (String) objLook);
                } else if (fCgInterface != null) {
                    fCgInterface.getLangDoc().getDescriptionList().add(
                            (String) objLook);
                } else {
                    throw new IllegalArgumentException(
                            "ClassExpander: NXłC^tF[XłȂԂ̂̂expand悤Ƃ܂B");
                }
            } else {
                throw new IllegalArgumentException("ClassExpander: JavaDoc["
                        + objLook + "]̌^[" + objLook.getClass().getName()
                        + "]͏ł܂B");
            }
        }

        // \bhWJB
        for (int index = 0; index < fMethodList.size(); index++) {
            final MethodExpander argMethod = (MethodExpander) fMethodList
                    .get(index);
            argMethod.setupSignature();
            argMethod.implement();

            if (fCgClass != null) {
                fCgClass.getMethodList().add(argMethod.getCgMethod());
            } else {
                fCgInterface.getMethodList().add(argMethod.getCgMethod());
            }

            // importWJ܂B
            for (int indexImport = 0; indexImport < argMethod.getImportList()
                    .size(); indexImport++) {
                final String newImport = (String) argMethod.getImportList()
                        .get(indexImport);
                fImportList.add(newImport);
            }
        }

        // tB[hWJB
        // |CgF\bhWJ̌ʃtB[hǉꍇ̂ŁA\bhWJɃtB[hWJ{Kv܂B
        for (int index = 0; index < fFieldList.size(); index++) {
            final FieldExpander argField = (FieldExpander) fFieldList
                    .get(index);
            if (fCgClass != null) {
                fCgClass.getFieldList().add(argField.getCgField());
            } else {
                fCgInterface.getFieldList().add(argField.getCgField());
            }
        }

        // tB[hWJB
        for (int index = 0; index < fFieldList.size(); index++) {
            final FieldExpander argField = (FieldExpander) fFieldList
                    .get(index);
            argField.expand();
        }

        // \bhWJB
        for (int index = 0; index < fMethodList.size(); index++) {
            final MethodExpander argMethod = (MethodExpander) fMethodList
                    .get(index);
            argMethod.expand();
        }
    }

    /**
     * ̃NX̃NX擾܂B
     * 
     * @return NXB(pbP[W)
     */
    public final String getName() {
        if (fCgClass != null) {
            return fCgClass.getName();
        } else if (fCgInterface != null) {
            return fCgInterface.getName();
        } else {
            throw new IllegalArgumentException(
                    "NXƂĂC^tF[XƂĂł܂Bf܂B");
        }
    }

    /**
     * IɕێĂ blancoCg\擾܂B
     * 
     * @return class\B
     */
    public final BlancoCgClass getCgClass() {
        return fCgClass;
    }

    /**
     * IɕێĂ blancoCg\擾܂B
     * 
     * @return interface\B
     */
    public final BlancoCgInterface getCgInterface() {
        return fCgInterface;
    }

    /**
     * ̃NXblancoCodeGeneratorƂĂ̌^擾܂B
     * 
     * @return blancoCodeGeneratorƂĂ̌^B
     */
    public final Type getType() {
        return fType;
    }

    /**
     * pbP[W擾܂B
     * 
     * @return ̃NX̃pbP[WB
     */
    public final String getPackage() {
        final String className = BlancoNameUtil.trimJavaPackage(getType()
                .getFullName());
        return getType().getFullName().substring(0,
                getType().getFullName().length() - className.length() - 1);
    }

    /**
     * blancoCodeGeneratorƂĂJavaDoc\擾܂B
     * 
     * @return
     */
    public final ClassJavaDoc getJavaDoc() {
        return fJavaDoc;
    }

    /**
     * ̃NX̐eNXw肵܂B
     * 
     * @param argType
     *            eNXB
     */
    public final void setSuperClass(final Type argType) {
        if (fCgClass != null) {
            fCgClass.getExtendClassList().add(
                    fCgFactory.createType(argType.getFullName()));
        } else {
            fCgInterface.getExtendClassList().add(
                    fCgFactory.createType(argType.getFullName()));
        }
    }

    /**
     * t@CRgǉ܂B
     * 
     * @param argComment
     */
    public final void addFileComment(final String argComment) {
        fSourceFileComment.add(argComment);
    }

    /**
     * importǉ܂B
     * 
     * @param argType
     */
    public final void addImport(final Type argType) {
        fImportList.add(BlancoCodeGeneratorUtil.normalizeTypeName(argType
                .getFullName()));
    }

    /**
     * ̃NXɃtB[hǉ܂B
     * 
     * @param argField
     */
    public final void addField(final FieldExpander argField) {
        fFieldList.add(argField);
    }

    /**
     * ̃NXɃ\bhǉ܂B
     * 
     * @param argMethod
     */
    public final void addMethod(final MethodExpander argMethod) {
        fMethodList.add(argMethod);
    }

    /**
     * \[XR[h𐶐܂B
     * 
     * @param argClassExpander
     * @param directoryTarget
     */
    public static final void generateJavaSource(
            final ClassExpander argClassExpander, final File directoryTarget) {
        final GeneratorSetting setting = new GeneratorSetting();
        // o͐fBNgݒ肵܂B
        setting.setWorkDirectory(directoryTarget.getAbsolutePath());
        final ImplementGenerator implementGenerator = new ImplementGenerator(
                setting);
        // 쐬NXo^܂B
        implementGenerator.addMain(argClassExpander);
        try {
            // ۂɃ\[XR[hs܂B
            implementGenerator.generate();
            // System.out.println("\[XR[h܂B");
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\[XR[hɓo͗O܂B:"
                    + e.toString());
        }
    }

    /**
     * t@CRg擾܂B
     * 
     * @return
     */
    public final ArrayList getSourceFileComment() {
        return fSourceFileComment;
    }
}
