/*
 * blancoCodeGenerator
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.method;

import java.util.ArrayList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgException;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgParameter;
import blanco.cg.valueobject.BlancoCgReturn;
import blanco.commons.util.BlancoStringUtil;
import blanco.ig.expander.BlancoCodeGeneratorUtil;
import blanco.ig.expander.Expander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.ImplementData;
import blanco.ig.expander.javadoc.MethodJavaDoc;

/**
 * blancoCodeGenerator̃\bh킷NXłB
 * 
 * @author Yasuo Nakanishi (1st version)
 * @author IGA Tosiki (2nd version)
 */
public abstract class MethodExpander extends Expander {
    /**
     * blanco Framework̃IuWFNgt@NgB
     */
    private final BlancoCgObjectFactory fCgFactory = BlancoCgObjectFactory
            .getInstance();

    /**
     * blancoCgMethod\B
     */
    private BlancoCgMethod fCgMethod = null;

    /**
     * blancoCodeGeneratorIɕێ JavaDocB
     */
    private final MethodJavaDoc fJavaDoc = new MethodJavaDoc();

    /**
     * blancoCodeGeneratorƂēIɕێ importListB
     */
    private final ArrayList fImportList = new ArrayList();

    /**
     * \bh\NX𐶐܂B
     * 
     * @param argName
     *            \bhB
     */
    public MethodExpander(final String argName) {
        fCgMethod = fCgFactory.createMethod(argName, "");

        fCgMethod.setAccess(getScope().get());
        fCgMethod.setAbstract(isAbstract());
        fCgMethod.setStatic(isStatic());
        fCgMethod.setFinal(isFinal());
    }

    /**
     * \bh̃VOj`\z邽߂̃\bhB
     * 
     * pœe܂B
     */
    public abstract void setupSignature();

    /**
     * \bh̖{̂\z邽߂̃\bhB
     * 
     * pœe܂B
     */
    public abstract void implement();

    /**
     * \[XR[hɓWJ邽߂̃\bhB
     */
    public final void expand() {
        // LangDoc̈ڑB
        for (int index = 0; index < fJavaDoc.getList().size(); index++) {
            final Object objLook = fJavaDoc.getList().get(index);
            if (objLook instanceof String) {
                fCgMethod.getLangDoc().getDescriptionList().add(
                        (String) objLook);
            } else if (objLook instanceof BlancoCgParameter) {
                final BlancoCgParameter cgParameter = (BlancoCgParameter) objLook;
                for (int indexParameter = 0; indexParameter < fCgMethod
                        .getParameterList().size(); indexParameter++) {
                    final BlancoCgParameter cgParameterLook = (BlancoCgParameter) fCgMethod
                            .getParameterList().get(indexParameter);
                    if (cgParameter.getName().equals(cgParameterLook.getName())) {
                        // v܂Bdescriptionڑ܂B
                        // ӁBLangDocł͂Ȃp[^{̂DescriptionɈڑĂ_ɒځB
                        cgParameterLook.setDescription(cgParameter
                                .getDescription());
                        break;
                    }
                }
            } else if (objLook instanceof BlancoCgReturn) {
                final BlancoCgReturn cgReturn = (BlancoCgReturn) objLook;
                // ӁBLangDocł͂ȂReturn{̂DescriptionɈڑĂ_ɒځB
                fCgMethod.getReturn().setDescription(cgReturn.getDescription());
            } else if (objLook instanceof BlancoCgException) {
                final BlancoCgException cgException = (BlancoCgException) objLook;
                for (int indexException = 0; indexException < fCgMethod
                        .getThrowList().size(); indexException++) {
                    final BlancoCgException cgExceptionLook = (BlancoCgException) fCgMethod
                            .getThrowList().get(indexException);
                    if (cgException.getType().getName().equals(
                            cgExceptionLook.getType().getName())) {
                        // v܂Bdescriptionڑ܂B
                        // ӁBLangDocł͂ȂO{̂DescriptionɈڑĂ_ɒځB
                        cgExceptionLook.setDescription(cgException
                                .getDescription());
                    }
                }
            } else {
                throw new IllegalArgumentException("\bhWJB̌hLg["
                        + objLook + "]A^[" + objLook.getClass().getName()
                        + "]܂B");
            }
        }
    }

    /**
     * ̃\bh̃\bh擾܂B
     * 
     * @return \bhB
     */
    public final String getName() {
        return fCgMethod.getName();
    }

    /**
     * IɕێĂ blancoCg\擾܂B
     * 
     * @return method\B
     */
    public final BlancoCgMethod getCgMethod() {
        return fCgMethod;
    }

    /**
     * blancoCodeGeneratorƂĂJavaDoc\擾܂B
     * 
     * @return JavaDoc\B
     */
    public final MethodJavaDoc getJavaDoc() {
        return fJavaDoc;
    }

    /**
     * ̃\bh{̂邽߂̃IuWFNg擾܂B
     * 
     * Ŏ擾IuWFNgɍsǉ邱Ƃɂ胁\bh\z܂B
     * 
     * @return R[hǉ邽߂̃IuWFNgB
     */
    public final ImplementData getData() {
        return new ImplementData(fCgMethod);
    }

    /**
     * C|[g̈ꗗ擾܂B
     * 
     * @return C|[g̈ꗗB
     */
    public final ArrayList getImportList() {
        return fImportList;
    }

    // TODO addImportIɂ͒ǉłB

    /**
     * p importǉ܂B
     * 
     * @param argType
     *            ^IuWFNgB
     */
    public final void addUsingType(final Type argType) {
        fImportList.add(BlancoCodeGeneratorUtil.normalizeTypeName(argType
                .getFullName()));
    }

    // TODO addParameterƂ\bh̒ǉÓƍl܂B
    // addParameter\bhɂ descriptionwł(blancoCgƓ)҂܂B

    /**
     * \bh p[^ǉ܂B
     * 
     * \bh addArgumentłAۂɂ̓p[^̒ǉ܂B
     * 
     * @param argValue
     *            p[^IuWFNgB
     */
    public final void addArgument(final Value argValue) {
        final String type = BlancoCodeGeneratorUtil.normalizeTypeName(argValue
                .getType().getFullName());
        // description͌hLgɐݒ肳ꂽlォ甽f܂B
        final BlancoCgParameter cgParameter = fCgFactory.createParameter(
                argValue.getName(), type, "");
        // ̏ꏊł [] ͕̏KvȏłB[]  z ւƓǂݑւKv邩łB
        if (argValue.getType().getFullName().endsWith("[]")) {
            cgParameter.getType().setArray(true);
        }

        if (BlancoStringUtil.null2Blank(argValue.getType().getGenerics())
                .length() > 0) {
            // WFlNXڑ܂B
            cgParameter.getType().setGenerics(argValue.getType().getGenerics());
        }

        fCgMethod.getParameterList().add(cgParameter);
    }

    /**
     * \bh return ݒ肵܂B
     * 
     * @param argType
     *            ߂l킷^IuWFNgB
     */
    public final void setReturnType(final Type argType) {
        final String type = BlancoCodeGeneratorUtil.normalizeTypeName(argType
                .getFullName());
        // description͌hLgɐݒ肳ꂽlォ甽f܂B
        final BlancoCgReturn cgReturn = fCgFactory.createReturn(type, "");
        // ̏ꏊł [] ͕̏KvȏłB[]  z ւƓǂݑւKv邩łB
        if (argType.getFullName().endsWith("[]")) {
            cgReturn.getType().setArray(true);
        }

        if (BlancoStringUtil.null2Blank(argType.getGenerics()).length() > 0) {
            // WFlNXڑ܂B
            cgReturn.getType().setGenerics(argType.getGenerics());
        }

        fCgMethod.setReturn(cgReturn);
    }

    /**
     * \bhɗOǉ܂B
     * 
     * @param argType
     *            O킷^IuWFNgB
     */
    public final void addException(final Type argType) {
        // ɓo^ς݂̃NXǂ`FbN܂B
        for (int index = 0; index < fCgMethod.getThrowList().size(); index++) {
            final BlancoCgException cgExceptionLook = (BlancoCgException) fCgMethod
                    .getThrowList().get(index);
            if (cgExceptionLook.getType().getName().equals(
                    argType.getFullName())) {
                throw new IllegalArgumentException("\bh["
                        + fCgMethod.getName() + "]œ̗ONX["
                        + argType.getFullName() + "]2x܂B");
            }
        }

        final BlancoCgException cgException = fCgFactory.createException(
                argType.getFullName(), "");

        if (BlancoStringUtil.null2Blank(argType.getGenerics()).length() > 0) {
            // WFlNXڑ܂B
            cgException.getType().setGenerics(argType.getGenerics());
        }

        fCgMethod.getThrowList().add(cgException);
    }
}
