/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.expander;

/**
 * .NET Frameworkp CodeGenerator֘ANX
 * 
 * @author IGA Tosiki
 */
public class TypeDotNet {

    private String _nameSpace = "";

    private String _name = "";

    private String _fullName = "";

    private boolean _array = false;

    public TypeDotNet(String name) {
        initialize(name);
    }

    public TypeDotNet(String nameSpace, String name) {
        _nameSpace = nameSpace;
        _name = name;
        _fullName = _nameSpace + "." + _name;
    }

    // ClassƂRXgN^͏܂B

    private void initialize(String name) {
        if (isPrimitive(name)) {
            _name = name;
        } else {
            _nameSpace = getNameSpace(name);
            _name = getClassName(name);
        }
        if (_array) {
            _name += "[]";
            _fullName = name + "[]";
        } else {
            _fullName = name;
        }
    }

    private String getNameSpace(String fullName) {
        int index = fullName.lastIndexOf(".");
        return fullName.substring(0, index);
    }

    private String getClassName(String fullName) {
        int index = fullName.lastIndexOf(".");
        return fullName.substring(index + 1, fullName.length());
    }

    public String getNameSpace() {
        return _nameSpace;
    }

    public boolean isPrimitive() {
        return _nameSpace.equals("");
    }

    public boolean isPrimitive(String fullName) {
        return fullName.indexOf(".") == -1;
    }

    public String getName() {
        return _name;
    }

    public String getFullName() {
        return _fullName;
    }

    public boolean equals(Object type) {
        boolean result = false;
        if (this == type) {
            result = true;
        } else if (type instanceof TypeDotNet) {
            TypeDotNet target = (TypeDotNet) type;
            if (getFullName().equals(target.getFullName())) {
                result = true;
            }
        } else if (type instanceof Class) {
            Class target = (Class) type;
            if (!target.isArray() && getFullName().equals(target.getName())) {
                result = true;
            } else if (target.isArray()
                    && getFullName().equals(
                            target.getComponentType().getName() + "[]")) {
                result = true;
            }
        } else if (type instanceof String) {
            String target = (String) type;
            if (getFullName().equals(target)) {
                result = true;
            }
        }
        return result;
    }

    public boolean isArray() {
        return _array;
    }

    public TypeDotNet getTestType() {
        return new TypeDotNet(getNameSpace(), getName() + "Test");
    }
}
