/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.dotnet.cg.expander.TypeDotNet;
import blanco.dotnet.cg.io.SourceFinderDotNet;
import blanco.dotnet.cg.io.SourceWriterDotNet;

/**
 * .NET Frameworkp CodeGenerator֘ANX<br>
 * 
 * @author IGA Tosiki
 */
public final class RuntimeGeneratorDotNet {
    private static final String ASSERTION_REGEX = "^[\\s]*?assert\\s*.*";

    private static final String HEADER_REGEX = "^[(using)|(namespace)].*";

    private GeneratorSettingDotNet _setting = null;

    private final List _runtimeResorceList = new ArrayList();

    private SourceWriterDotNet _sourceWriter = null;

    private final SourceFinderDotNet _finder = new SourceFinderDotNet();

    private final PackageTransformerDotNet _transformer = new PackageTransformerDotNet();

    public RuntimeGeneratorDotNet(final GeneratorSettingDotNet setting) {
        _setting = setting;
    }

    /**
     * Ώۂ̃\[XfBNgw肵܂B
     * 
     * @param path
     */
    public void addSourceDirectory(final String path) {
        _finder.addSourceDirectory(path);
    }

    /**
     * pbP[Wϊ[ǉ܂B
     * 
     * @param originalPackage
     * @param userPackage
     */
    public void addPackagePair(final String originalPackage,
            final String userPackage) {
        _transformer.addPackagePair(originalPackage, userPackage);
    }

    /**
     * ^CE\[XR[h𐶐܂
     * 
     * @throws IOException
     */
    public void generate(Class baseClass) throws IOException {
        final Iterator iterator = _runtimeResorceList.iterator();
        while (iterator.hasNext()) {
            generateRuntime(baseClass, (TypeDotNet) iterator.next());
        }
    }

    /**
     * ^ꂽ^CƂɁA\[XR[hۂɐ܂B
     * 
     * @param runtimeClass
     * @throws IOException
     */
    private void generateRuntime(Class baseClass, TypeDotNet runtimeClass)
            throws IOException {
        final String outputPath = _setting.getMainOutputDirectory();
        final String sourcePath = _finder
                .getSourcePath(baseClass, runtimeClass);
        final String resourcePath = _finder.getResourcePath(baseClass,
                runtimeClass);
        final String targetPath = _transformer.getTargetPath(outputPath,
                resourcePath);
        final List generateSourceCodeList = new ArrayList();

        _sourceWriter = new SourceWriterDotNet(_setting.getSoruceEncoding());

        boolean isInFileHeader = true;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(
                    getStream(sourcePath)));

            for (;;) {
                final String line = reader.readLine();
                if (line == null) {
                    // I[ɓB܂B
                    break;
                }

                if (isInFileHeader) {
                    if (line.matches(HEADER_REGEX)) {
                        // t@C̃wb_[u܂B
                        isInFileHeader = false;
                        generateSourceCodeList.add("/*");
                        generateSourceCodeList
                                .add(" * This code is generated by blanco Framework.");
                        generateSourceCodeList.add(" */");
                    }
                }

                if (!isInFileHeader && line.matches(ASSERTION_REGEX)) {
                    generateSourceCodeList.add("");
                } else if (!isInFileHeader) {
                    generateSourceCodeList.add(_transformer
                            .replacePackage(line));
                }
            }
            _sourceWriter.write(targetPath, generateSourceCodeList);

            if (_sourceWriter.isCreated()) {
                System.out.println("NX:" + runtimeClass.getName());
            } else if (_sourceWriter.isUpdated()) {
                System.out.println("XVNX:" + runtimeClass.getName());
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /**
     * Xg[擾܂B<br>
     * ^ꂽpXt@CĂt@C̓Xg[A<br>
     * łȂ΁ANX[_[烊\[XXg[擾܂B
     * 
     * @param targetPath
     * @return
     * @throws FileNotFoundException
     */
    private InputStream getStream(final String targetPath)
            throws FileNotFoundException {
        InputStream result = null;
        final File fileRead = new File(targetPath);
        if (fileRead.exists()) {
            result = new FileInputStream(fileRead);
        } else {
            result = getClass().getClassLoader()
                    .getResourceAsStream(targetPath);
        }
        return result;
    }

    public void addRuntime(final TypeDotNet runtimeClass) {
        _runtimeResorceList.add(runtimeClass);
    }
}
