package blanco.dotnet.cg.expander;

import java.io.File;

import junit.framework.TestCase;
import blanco.dotnet.cg.expander.field.FieldExpanderDotNet;
import blanco.dotnet.cg.expander.method.MethodExpanderDotNet;

public class ClassExpanderDotNetTest extends TestCase {
    public void testMain() throws Exception {
        final ClassExpanderDotNet classExpander = new ClassExpanderDotNet(
                new TypeDotNet("My.Pkg", "MyClass")) {
            protected void expandClassStruct() {
                addFileComment("̃Tv͋@BIɐ܂B");
                getJavaDoc().addLine("͂߂ẴNX̃Tv<br>");
                getJavaDoc().addLine(
                        "̃TvblancoCodeGeneratorDotNetɂ@BIɎĂ܂B");
                addAnnotation("abc=def");

                FieldExpanderDotNet field = new FieldExpanderDotNet(
                        new TypeDotNet("System.Date"), "fDate");
                field.getJavaDoc().addLine("tB[hRg");
                field.addAnnotation("field=abc");
                addField(field);

                // addMethod(new ConstructorDotNet("MyClass") {
                // protected String makeSignature() {
                // return makeSignature(true);
                // }
                //
                // public void setupSignature() {
                // getJavaDoc().addLine("RXgN^̃eXg");
                // setBase("123");
                // }
                //
                // public void implement() {
                // }
                // });

                addMethod(new MethodExpanderDotNet("MyMethod") {
                    public void setupSignature() {
                        addUsingType(new TypeDotNet("System"));
                        addUsingType(new TypeDotNet("System.Drawing"));
                        addUsingType(new TypeDotNet("System.Collections"));
                        addUsingType(new TypeDotNet("System.ComponentModel"));
                        addUsingType(new TypeDotNet("System.Windows.Forms"));
                        addUsingType(new TypeDotNet("System.Data"));
                        addUsingType(new TypeDotNet("System.Data.OleDb"));
                        addUsingType(new TypeDotNet("System.Data.Odbc"));

                        getJavaDoc().addLine("Rg̃eXg");
                        addAnnotation("efg=hij");
                    }

                    public void implement() {
                        getData().addLine("if (true)");
                        getData().addLine("{");
                        getData().addLine("}");
                    }
                });
            }
        };
        new File("blanco").mkdirs();
        ClassExpanderDotNet.generateJavaSource(classExpander,
                new File("blanco"));

    }
}
