/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.expander.implementor;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

import blanco.dotnet.cg.expander.ClassExpanderDotNet;

/**
 * .NET Frameworkp CodeGenerator֘ANX
 * 
 * @author IGA Tosiki
 */
public class ImplementDataDotNet {
    private List _implementList = null;

    private List _usingTypeList = null;

    private int _indentDepth = 2;

    private Stack _blockStack = new Stack();

    public ImplementDataDotNet() {
        _implementList = new ArrayList();
        _usingTypeList = new ArrayList();
    }

    public ImplementDataDotNet(List implementList, List usingTypeList) {
        _implementList = implementList;
        _usingTypeList = usingTypeList;
    }

    public boolean isEmpty() {
        return _implementList.size() == 0;
    }

    public void pushBlock(BlockDotNet block) {
        _blockStack.push(block);
    }

    public BlockDotNet getCurrentBlock() {
        return (BlockDotNet) _blockStack.peek();
    }

    public String indent(String line) {
        StringBuffer sb = new StringBuffer(line);
        sb.insert(0, ClassExpanderDotNet.INDENT);
        for (int i = 0; i < _indentDepth; i++) {
            sb.insert(0, ClassExpanderDotNet.INDENT);
        }
        return new String(sb);
    }

    public void addLine(String line) {
        if (isBlockEnd(line)) {
            _indentDepth--;
        }
        _implementList.add(indent(line));

        if (isBlockStart(line)) {
            _indentDepth++;
        }
    }

    private boolean isBlockEnd(String line) {
        boolean result = false;
        if (line.startsWith("}")) {
            result = true;
        }
        return result;
    }

    private boolean isBlockStart(String line) {
        boolean result = false;
        if (line.endsWith("{")) {
            result = true;
        }
        return result;
    }

    public void popBlock() {
        _blockStack.pop();
    }

    public List getImplementList() {
        return _implementList;
    }

    public List getUsingTypeList() {
        return _usingTypeList;
    }
}
