/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.expander.implementor;

import blanco.dotnet.cg.expander.TypeDotNet;
import blanco.dotnet.cg.expander.ValueDotNet;

/**
 * .NET Frameworkp CodeGenerator֘ANX
 * 
 * @author IGA Tosiki
 * @deprecated Ƃ ͗pȂłB
 */
public class ReceiverDotNet extends StatementDotNet {
    private String _name = "";

    private TypeDotNet _staticClass = null;

    private CallDotNet _call = null;

    public ReceiverDotNet(String name) {
        _name = name;
    }

    public ReceiverDotNet(String name, String methodName) {
        this(name);
        call(methodName);
    }

    public ReceiverDotNet(ValueDotNet value) {
        this(value.getName());
    }

    public ReceiverDotNet(ValueDotNet value, String methodName) {
        this(value);
        call(methodName);
    }

    public ReceiverDotNet(TypeDotNet staticClass, String name) {
        _staticClass = staticClass;
        _name = name;
        addUsingType(staticClass);
    }

    public CallDotNet call(String methodName) {
        _call = new CallDotNet(methodName);
        addSubStatement(_call);
        return _call;
    }

    public CallDotNet getCalledMethod() {
        return _call;
    }

    public String getStatementString() {
        StringBuffer sb = new StringBuffer();
        if (_staticClass != null) {
            sb.append(_staticClass.getName());
            sb.append(".");
        }
        sb.append(_name);
        if (_call != null) {
            sb.append(".");
            sb.append(_call.toString());
        }
        return sb.toString();
    }
}
