/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.io;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import blanco.dotnet.cg.expander.TypeDotNet;

/**
 * .NET Frameworkp CodeGenerator֘ANX<br>
 * 
 * @author IGA Tosiki
 */
public class SourceFinderDotNet {
    private List _sourceDirectories = new ArrayList();

    public SourceFinderDotNet() {

    }

    public void addSourceDirectory(String path) {
        _sourceDirectories.add(path);
    }

    private String toPath(TypeDotNet targetClass) {
        return targetClass.getFullName().replaceAll("\\.", "/") + ".cs";
    }

    private String findFileSystem(String sourcePath) {
        String result = null;
        String path = "";
        String sourceDirectory = "";
        for (int i = 0; i < _sourceDirectories.size(); i++) {
            sourceDirectory = (String) _sourceDirectories.get(i);
            path = sourceDirectory + "/" + sourcePath;
            if (new File(path).exists()) {
                result = path;
            }
        }
        if (result == null) {
            throwException(sourcePath);
        }
        return result;
    }

    private void throwException(String sourcePath) {
        String message = "\[X܂łBPath:" + sourcePath;
        throw new RuntimeException(message);
    }

    private String findFromClassPath(Class baseClass, TypeDotNet targetClass,
            String sourcePath) {
        String result = "";
        if (baseClass.getClassLoader().getResource(sourcePath) != null) {
            result = sourcePath;
        } else {
            throwException(sourcePath);
        }
        return result;
    }

    public String getSourcePath(Class baseClass, TypeDotNet targetClass) {
        String result = null;
        String sourcePath = toPath(targetClass);

        try {
            result = findFileSystem(sourcePath);
        } catch (RuntimeException e) {
            result = findFromClassPath(baseClass, targetClass, sourcePath);
        }
        return result;
    }

    public String getResourcePath(Class baseClass, TypeDotNet targetClass) {
        return toPath(targetClass);
    }
}
