/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobject.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.valueobject.BlancoValueObjectDotNetMeta2Xml;
import blanco.valueobject.BlancoValueObjectDotNetXml2CsClass;
import blanco.valueobject.resourcebundle.BlancoValueObjectDotNetResourceBundle;

public class BlancoValueObjectDotNetTask extends
        AbstractBlancoValueObjectDotNetTask {
    private final BlancoValueObjectDotNetResourceBundle bundle = new BlancoValueObjectDotNetResourceBundle();

    protected void process() throws IllegalArgumentException {
        try {
            File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg[" + getMetadir()
                        + "]݂܂B");
            }

            // e|fBNg쐬B
            new File(getTmpdir() + bundle.getTargetDirectory()).mkdirs();

            new BlancoValueObjectDotNetMeta2Xml().processDirectory(fileMetadir,
                    getTmpdir() + bundle.getTargetDirectory());

            // XMLꂽ^t@CValueObject𐶐
            // ŏɃe|tH_𑖍
            final File[] fileMeta2 = new File(getTmpdir()
                    + bundle.getTargetDirectory()).listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoValueObjectDotNetXml2CsClass().process(
                        fileMeta2[index], new File(getTargetdir()));
            }

            // Ƀ^fBNgƂĎw肳ĂfBNg𑖍
            final File[] fileMeta3 = fileMetadir.listFiles();
            for (int index = 0; index < fileMeta3.length; index++) {
                if (fileMeta3[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoValueObjectDotNetXml2CsClass().process(
                        fileMeta3[index], new File(getTargetdir()));
            }
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }
}
