/*
 * blancoCsv Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.csv.expand;

import java.io.File;

import blanco.csv.resourcebundle.BlancoCsvRuntimeUtilResourceBundle;
import blanco.csv.valueobject.BlancoCsvStructure;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.MethodExpander;

public class BlancoCsvExpandRuntimeUtil {
    final BlancoCsvRuntimeUtilResourceBundle bundle = new BlancoCsvRuntimeUtilResourceBundle();

    public void expand(final BlancoCsvStructure processStructure,
            final File directoryTarget) {

        final String className = bundle.getClassName();
        final String classNameblancoCsvIOException = processStructure
                .getRuntimePackage()
                + ".io.BlancoCsvIOException";
        final ClassExpander classExpander = new ClassExpander(new Type(
                processStructure.getRuntimePackage()
                        + bundle.getPackagePrefix(), className)) {
            protected void expandClassStruct() {
                addFileComment(bundle.getFilecomment());
                getJavaDoc().addLine(bundle.getClasscomment01());
                getJavaDoc().addLine(bundle.getClasscomment02());

                addMethod(new MethodExpander(bundle.getReadtokenName()) {
                    protected boolean isStatic() {
                        return true;
                    }

                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine(bundle.getReadtokenJavadoc());
                        addArgument(new Value(new Type(bundle
                                .getReadtokenArg01Type()), bundle
                                .getReadtokenArg01Name()));
                        getJavaDoc().addParameter(
                                bundle.getReadtokenArg01Name(),
                                bundle.getReadtokenArg01Javadoc());

                        addArgument(new Value(new Type(bundle
                                .getReadtokenArg02Type()), bundle
                                .getReadtokenArg02Name()));
                        getJavaDoc().addParameter(
                                bundle.getReadtokenArg02Name(),
                                bundle.getReadtokenArg02Javadoc());

                        addArgument(new Value(new Type(bundle
                                .getReadtokenArg03Type()), bundle
                                .getReadtokenArg03Name()));
                        getJavaDoc().addParameter(
                                bundle.getReadtokenArg03Name(),
                                bundle.getReadtokenArg03Javadoc());

                        setReturnType(new Type(bundle.getReadtokenReturnType()));
                        getJavaDoc().addReturn(
                                bundle.getReadtokenReturnJavadoc());

                        addException(new Type(classNameblancoCsvIOException));
                        getJavaDoc().addException(
                                new Type(classNameblancoCsvIOException),
                                "ڐȂȂǗ^ꂽɊւOꍇB");
                        addException(new Type(bundle.getReadtokenThrows01Type()));
                        getJavaDoc().addException(
                                new Type(bundle.getReadtokenThrows01Type()),
                                bundle.getReadtokenThrows01Javadoc());
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine(bundle.getReadtokenLine01());
                        getData().addLine(bundle.getReadtokenLine02());
                        getData().addLine(bundle.getReadtokenLine03());
                        getData().addLine(bundle.getReadtokenLine04());
                        getData().addLine(bundle.getReadtokenLine05());
                        getData().addLine(bundle.getReadtokenLine06());
                        getData().addLine(bundle.getReadtokenLine07());
                        getData().addLine(bundle.getReadtokenLine08());
                        getData().addLine(bundle.getReadtokenLine09());
                        getData().addLine(bundle.getReadtokenLine10());
                        getData().addLine(bundle.getReadtokenLine11());
                        getData().addLine(bundle.getReadtokenLine12());
                        getData().addLine(bundle.getReadtokenLine13());
                        getData().addLine(bundle.getReadtokenLine14());
                        getData().addLine(bundle.getReadtokenLine15());
                        getData().addLine(bundle.getReadtokenLine16());
                        getData().addLine(bundle.getReadtokenLine17());
                        getData().addLine(bundle.getReadtokenLine18());
                        getData().addLine(bundle.getReadtokenLine19());
                        getData().addLine(bundle.getReadtokenLine20());
                    }
                });

                addMethod(new MethodExpander(bundle.getReadtokenwithquoteName()) {
                    protected boolean isStatic() {
                        return true;
                    }

                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                bundle.getReadtokenwithquoteJavadoc());

                        addArgument(new Value(new Type(bundle
                                .getReadtokenwithquoteArg01Type()), bundle
                                .getReadtokenwithquoteArg01Name()));
                        getJavaDoc().addParameter(
                                bundle.getReadtokenwithquoteArg01Name(),
                                bundle.getReadtokenwithquoteArg01Javadoc());

                        addArgument(new Value(new Type(bundle
                                .getReadtokenwithquoteArg02Type()), bundle
                                .getReadtokenwithquoteArg02Name()));
                        getJavaDoc().addParameter(
                                bundle.getReadtokenwithquoteArg02Name(),
                                bundle.getReadtokenwithquoteArg02Javadoc());

                        addArgument(new Value(new Type(bundle
                                .getReadtokenwithquoteArg03Type()), bundle
                                .getReadtokenwithquoteArg03Name()));
                        getJavaDoc().addParameter(
                                bundle.getReadtokenwithquoteArg03Name(),
                                bundle.getReadtokenwithquoteArg03Javadoc());

                        setReturnType(new Type(bundle
                                .getReadtokenwithquoteReturnType()));
                        getJavaDoc().addReturn(
                                bundle.getReadtokenwithquoteReturnJavadoc());

                        addException(new Type(classNameblancoCsvIOException));
                        getJavaDoc().addException(
                                new Type(classNameblancoCsvIOException),
                                "_uNI[g̕svȂǗ^ꂽɊւOꍇB");
                        addException(new Type(bundle
                                .getReadtokenwithquoteThrows01Type()));
                        getJavaDoc().addException(
                                new Type(bundle
                                        .getReadtokenwithquoteThrows01Type()),
                                bundle.getReadtokenwithquoteThrows01Javadoc());
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine(bundle.getReadtokenwithquoteLine01());
                        getData().addLine(bundle.getReadtokenwithquoteLine02());
                        getData().addLine(bundle.getReadtokenwithquoteLine03());
                        getData().addLine(bundle.getReadtokenwithquoteLine04());
                        getData().addLine(bundle.getReadtokenwithquoteLine05());
                        getData().addLine(bundle.getReadtokenwithquoteLine06());
                        getData().addLine(bundle.getReadtokenwithquoteLine07());
                        getData().addLine(bundle.getReadtokenwithquoteLine08());
                        getData().addLine(bundle.getReadtokenwithquoteLine09());
                        getData().addLine(bundle.getReadtokenwithquoteLine10());
                        getData().addLine(bundle.getReadtokenwithquoteLine11());
                        getData().addLine(bundle.getReadtokenwithquoteLine12());
                        getData().addLine(bundle.getReadtokenwithquoteLine13());
                        getData().addLine(bundle.getReadtokenwithquoteLine14());
                        getData().addLine(bundle.getReadtokenwithquoteLine15());
                        getData().addLine(bundle.getReadtokenwithquoteLine16());
                        getData().addLine(bundle.getReadtokenwithquoteLine17());
                        getData().addLine(bundle.getReadtokenwithquoteLine18());
                        getData().addLine(bundle.getReadtokenwithquoteLine19());
                        getData().addLine(bundle.getReadtokenwithquoteLine20());
                        getData().addLine(bundle.getReadtokenwithquoteLine21());
                        getData().addLine(bundle.getReadtokenwithquoteLine22());
                        getData().addLine(bundle.getReadtokenwithquoteLine23());
                        getData().addLine(bundle.getReadtokenwithquoteLine24());
                        getData().addLine(bundle.getReadtokenwithquoteLine25());
                        getData().addLine(bundle.getReadtokenwithquoteLine26());
                        getData().addLine(bundle.getReadtokenwithquoteLine27());
                        getData().addLine(bundle.getReadtokenwithquoteLine28());
                        getData().addLine(bundle.getReadtokenwithquoteLine29());
                        getData().addLine(bundle.getReadtokenwithquoteLine30());
                        getData().addLine(bundle.getReadtokenwithquoteLine31());
                        getData().addLine(bundle.getReadtokenwithquoteLine32());
                        getData().addLine(bundle.getReadtokenwithquoteLine33());
                        getData().addLine(bundle.getReadtokenwithquoteLine34());
                        getData().addLine(bundle.getReadtokenwithquoteLine35());
                        getData().addLine(bundle.getReadtokenwithquoteLine36());
                        getData().addLine(bundle.getReadtokenwithquoteLine37());
                        getData().addLine(bundle.getReadtokenwithquoteLine38());
                        getData().addLine(bundle.getReadtokenwithquoteLine39());
                        getData().addLine(bundle.getReadtokenwithquoteLine40());
                        getData().addLine(bundle.getReadtokenwithquoteLine41());
                        getData().addLine(bundle.getReadtokenwithquoteLine42());
                        getData().addLine(bundle.getReadtokenwithquoteLine43());
                        getData().addLine(bundle.getReadtokenwithquoteLine44());
                        getData().addLine(bundle.getReadtokenwithquoteLine45());
                        getData().addLine(bundle.getReadtokenwithquoteLine46());
                        getData().addLine(bundle.getReadtokenwithquoteLine47());
                        getData().addLine(bundle.getReadtokenwithquoteLine48());
                        getData().addLine(bundle.getReadtokenwithquoteLine49());
                        getData().addLine(bundle.getReadtokenwithquoteLine50());
                        getData().addLine(bundle.getReadtokenwithquoteLine51());
                        getData().addLine(bundle.getReadtokenwithquoteLine52());
                        getData().addLine(bundle.getReadtokenwithquoteLine53());
                        getData().addLine(bundle.getReadtokenwithquoteLine54());

                    }
                });

                addMethod(new MethodExpander(bundle.getGettokenwithquoteName()) {
                    protected boolean isStatic() {
                        return true;
                    }

                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                bundle.getGettokenwithquoteJavadoc());

                        addArgument(new Value(new Type(bundle
                                .getGettokenwithquoteArg01Type()), bundle
                                .getGettokenwithquoteArg01Name()));
                        getJavaDoc().addParameter(
                                bundle.getGettokenwithquoteArg01Name(),
                                bundle.getGettokenwithquoteArg01Javadoc());

                        setReturnType(new Type(bundle
                                .getGettokenwithquoteReturnType()));
                        getJavaDoc().addReturn(
                                bundle.getGettokenwithquoteReturnJavadoc());

                        addException(new Type(bundle
                                .getGettokenwithquoteThrows01Type()));
                        getJavaDoc().addException(
                                new Type(bundle
                                        .getGettokenwithquoteThrows01Type()),
                                bundle.getGettokenwithquoteThrows01Javadoc());
                    }

                    // \bh̎
                    public void implement() {
                        addUsingType(new Type(bundle
                                .getGettokenwithquoteAddusingtype01()));
                        addUsingType(new Type(bundle
                                .getGettokenwithquoteAddusingtype02()));
                        getData().addLine(bundle.getGettokenwithquoteLine01());
                        getData().addLine(bundle.getGettokenwithquoteLine02());
                        getData().addLine(bundle.getGettokenwithquoteLine03());
                        getData().addLine(bundle.getGettokenwithquoteLine04());
                        getData().addLine(bundle.getGettokenwithquoteLine05());
                        getData().addLine(bundle.getGettokenwithquoteLine06());
                        getData().addLine(bundle.getGettokenwithquoteLine07());
                        getData().addLine(bundle.getGettokenwithquoteLine08());
                        getData().addLine(bundle.getGettokenwithquoteLine09());
                        getData().addLine(bundle.getGettokenwithquoteLine10());
                        getData().addLine(bundle.getGettokenwithquoteLine11());
                        getData().addLine(bundle.getGettokenwithquoteLine12());
                        getData().addLine(bundle.getGettokenwithquoteLine13());
                        getData().addLine(bundle.getGettokenwithquoteLine14());
                        getData().addLine(bundle.getGettokenwithquoteLine15());
                        getData().addLine(bundle.getGettokenwithquoteLine16());
                        getData().addLine(bundle.getGettokenwithquoteLine17());
                        getData().addLine(bundle.getGettokenwithquoteLine18());
                        getData().addLine(bundle.getGettokenwithquoteLine19());
                        getData().addLine(bundle.getGettokenwithquoteLine20());
                        getData().addLine(bundle.getGettokenwithquoteLine21());
                    }
                });
            }
        };

        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
