/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.Type;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.method.IgConstructor;
import blanco.ig.expander.method.MethodExpander;

public class BlancoEclipsePluginGenExpandWizardPage99 {
    public static final void expand(final Element elementCommon,
            final NodeList listList, final File directoryTarget) {
        final String pluginName = BlancoXmlUtil.getTextContent(elementCommon,
                "name");
        final String displayName = BlancoXmlUtil.getTextContent(elementCommon,
                "displayName");

        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");

        final String className = "Abstract"
                + BlancoNameAdjuster.toClassName(pluginName) + "WizardPage99";
        final ClassExpander classExpander = new ClassExpander(new Type(
                packageName + ".wizards", className)) {
            protected boolean isAbstract() {
                return true;
            }

            protected void expandClassStruct() {
                setSuperClass(new IgType("org.eclipse.jface.wizard.WizardPage"));

                addImport(new IgType("org.eclipse.swt.SWT"));
                addImport(new IgType("org.eclipse.swt.layout.GridLayout"));
                addImport(new IgType("org.eclipse.swt.widgets.Label"));
                addImport(new IgType(packageName + ".editors."
                        + BlancoNameAdjuster.toClassName(pluginName) + "Editor"));

                final FieldExpander fieldSelection = new FieldExpander(
                        new IgType("org.eclipse.jface.viewers.ISelection"),
                        "selection");
                addField(fieldSelection);

                addMethod(new IgConstructor(className) {
                    public void setupSignature() {
                        addArgument(new IgValue(new IgType(
                                "org.eclipse.jface.viewers.ISelection"),
                                "selection"));
                    }

                    public void implement() {
                        getData().addLine("super(\"wizardPage\");");
                        getData().addLine(
                                "setTitle(\"" + displayName
                                        + "vOCpxEBU[h̊\");");
                        getData().addLine("this.selection = selection;");
                    }
                });

                addMethod(new MethodExpander("createControl") {
                    public void setupSignature() {
                        addArgument(new IgValue(new IgType(
                                "org.eclipse.swt.widgets.Composite"), "parent"));
                    }

                    public void implement() {
                        getData().addLine(
                                "GridLayout gridLayout = new GridLayout();");
                        getData().addLine("gridLayout.numColumns = 1;");
                        getData().addLine("");
                        getData()
                                .addLine(
                                        "Composite container = new Composite(parent, SWT.NULL);");
                        getData().addLine("container.setLayout(gridLayout);");
                        getData().addLine("");
                        getData().addLine(
                                "new Label(container, SWT.NONE).setText(\""
                                        + displayName
                                        + "vOCpxEBU[h Ŋ܂B\");");
                        getData().addLine(
                                "new Label(container, SWT.NONE).setText(\"  1.EBU[h u"
                                        + displayName
                                        + "ݒt@C GfB^v\܂B\");");
                        getData()
                                .addLine(
                                        "new Label(container, SWT.NONE).setText(\"    ̉ʂ \" + "
                                                + pluginName
                                                + "Editor.TARGET_FILENAME + \"t@C̃GfB^vOɑ܂B\");");
                        getData()
                                .addLine(
                                        "new Label(container, SWT.NONE).setText(\"  2.ʕ\ɏ]đi߂ĂB\");");
                        getData().addLine("");
                        getData().addLine("setControl(container);");
                    }
                });
            }
        };

        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
