/*
 * blancoCsv Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.csv.expand;

import java.io.File;

import blanco.csv.resourcebundle.BlancoCsvIOExceptionResourceBundle;
import blanco.csv.valueobject.BlancoCsvStructure;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.Constructor;

public class BlancoCsvExpandIOException {
    private final BlancoCsvIOExceptionResourceBundle bundle = new BlancoCsvIOExceptionResourceBundle();

    public void expand(final BlancoCsvStructure processStructure,
            final File directoryTarget) {

        final String packageName = processStructure.getRuntimePackage()
                + bundle.getPackagePrefix();
        final ClassExpander classExpander = new ClassExpander(new Type(
                packageName, bundle.getClassName())) {
            protected void expandClassStruct() {
                setSuperClass(new Type(bundle.getSuperclassName()));
                addFileComment(bundle.getFilecomment());

                getJavaDoc().addLine(bundle.getClasscomment01());
                getJavaDoc().addLine(bundle.getClasscomment02());

                addMethod(new Constructor(bundle.getClassName()) {
                    public void setupSignature() {
                        getJavaDoc().addLine("bZ[W𔺂blancoCsvONX𐶐܂B");
                        getJavaDoc().addParameter(
                                bundle.getConstructor01Arg01Name(), "bZ[WB");
                        addArgument(new Value(new Type(bundle
                                .getConstructor01Arg01Type()), bundle
                                .getConstructor01Arg01Name()));
                    }

                    public void implement() {
                        getData().addLine(bundle.getConstructor01Line01());
                    }
                });

                addMethod(new Constructor(bundle.getClassName()) {
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                "bZ[Wь𔺂blancoCsvONX𐶐܂B");
                        getJavaDoc().addParameter(
                                bundle.getConstructor01Arg01Name(), "bZ[WB");
                        getJavaDoc().addParameter("argCause", "ƂȂOIuWFNgB");
                        addArgument(new Value(new Type(bundle
                                .getConstructor01Arg01Type()), bundle
                                .getConstructor01Arg01Name()));
                        addArgument(new Value(new Type("java.lang.Throwable"),
                                "argCause"));
                    }

                    public void implement() {
                        getData().addLine("super(message, argCause);");
                    }
                });
            }
        };

        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
