/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.csv.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.csv.BlancoCsvConstants;
import blanco.csv.BlancoCsvMeta2Xml;
import blanco.csv.BlancoCsvXml2JavaClass;

/**
 * BlancoCsvAnt^XNłB
 * 
 * @author IGA Tosiki
 */
public class BlancoCsvTask extends AbstractBlancoCsvTask {

    /**
     * AntTask̏s܂B
     * 
     * ̃\bh ېeNXłAbstractBlancoCsvTaskNXĂяo܂B
     * 
     * @throws IllegalArgumentException
     *             e͒lȌꍇɔ܂B
     */
    protected void process() throws IllegalArgumentException {
        try {
            final File blancoTmpDirectory = new File(getTmpdir()
                    + BlancoCsvConstants.TARGET_DIRECTORY);
            blancoTmpDirectory.mkdirs();

            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg[" + getMetadir()
                        + "]݂܂B");
            }

            new BlancoCsvMeta2Xml().processDirectory(fileMetadir, getTmpdir()
                    + BlancoCsvConstants.TARGET_DIRECTORY);

            final File tempValueObjectFolder = new File(getTmpdir()
                    + BlancoCsvConstants.TARGET_DIRECTORY
                    + BlancoCsvConstants.VALUE_OBJECT_DIRECTORY);
            tempValueObjectFolder.mkdirs();

            final File[] fileTmp = blancoTmpDirectory.listFiles();
            for (int index = 0; index < fileTmp.length; index++) {
                if (fileTmp[index].getName().endsWith(".xml")) {
                    new BlancoCsvXml2JavaClass()
                            .process(fileTmp[index], getRuntimepackage(),
                                    tempValueObjectFolder, new File(
                                            getTargetdir()), getJunit().equals(
                                            "true"));
                }
            }
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }
}
