package blanco.plugin.csv.editors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;

import javax.xml.transform.dom.DOMResult;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.plugin.csv.BlancoCsvPlugin;
import blanco.plugin.csv.actions.BlancoCsvGenerateAction;

/**
 * blancoCsvGfB^ <br>
 * 
 * @author iga
 */
public class BlancoCsvEditor extends AbstractBlancoCsvEditor {

    private Composite top = null;

    public static final String TARGET_FILENAME = "blancocsv.blancofw";

    public static final String BLANCO_META_FILE = "t@C`(CSV)";

    // rWÄ
    private Label labelBlancoCsvTitle = null;

    private Label labelBlancoCsvSettingId = null;

    private Text textBlancoCsvSettingId = null;

    private Combo comboRuntimePackage = null;

    private Label labelMetadir = null;

    private Combo comboMetadir = null;

    private Label labelMetadirComment = null;

    private Label labelSettingComment = null;

    private Button buttonExecuteJavaSource = null;

    private Button buttonExecuteCsSource = null;

    private Button buttonCreateMetafile = null;

    public void createPartControl(Composite parent) {
        top = parent;
        top.setSize(new org.eclipse.swt.graphics.Point(1000, 400));

        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout(layout);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoCsvTitle = new Label(top, SWT.NONE);
        labelBlancoCsvTitle.setText("BlancoCsvݒt@C GfB^");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoCsvSettingId = new Label(top, SWT.NONE);
        labelBlancoCsvSettingId.setText("ݒID");
        textBlancoCsvSettingId = new Text(top, SWT.BORDER);
        textBlancoCsvSettingId.setText("blancoCsv");
        textBlancoCsvSettingId.setEditable(false);

        final Label labelRuntimePackage = new Label(top, SWT.NONE);
        labelRuntimePackage.setText("^CpbP[W");
        createComboRuntimePackage();

        labelMetadir = new Label(top, SWT.NONE);
        labelMetadir.setText("^fBNg");
        createComboMetadir();

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelMetadirComment = new Label(top, SWT.NONE);
        labelMetadirComment.setText("^fBNg͒ʏύXɗp܂B");
        labelMetadirComment.setSize(new org.eclipse.swt.graphics.Point(500,
                30 + 20));

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonCreateMetafile = new Button(top, SWT.NONE);
        buttonCreateMetafile.setText(BLANCO_META_FILE + " VK쐬");
        buttonCreateMetafile
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        // ^t@C쐬̍ۂɂ́A̍ڂ̃`FbN͍s܂B
                        saveToTextEditor();

                        if (comboMetadir.getText().length() == 0) {
                            MessageDialog
                                    .openWarning(
                                            top.getShell(),
                                            BLANCO_META_FILE + " VK쐬",
                                            "^fBNgw肵ĂB\n"
                                                    + "^fBNg̈ʓIȐݒl 'meta/csv' łB");
                            return;
                        }

                        final IFileEditorInput input = (IFileEditorInput) getEditorInput();

                        try {
                            if (BlancoCsvPluginUtil.findFolder(input.getFile(),
                                    getProgressMonitor(),
                                    comboMetadir.getText()).exists() == false) {
                                BlancoCsvPluginUtil.createFolder(input
                                        .getFile(), getProgressMonitor(),
                                        comboMetadir.getText());

                                MessageDialog.openInformation(top.getShell(),
                                        "^fBNg̍쐬", "^fBNg ["
                                                + comboMetadir.getText()
                                                + "] VKɍ쐬܂B\n"
                                                + "ɂ̂ݕKvȓłB");
                            }
                        } catch (CoreException e3) {
                            MessageDialog.openWarning(top.getShell(),
                                    BLANCO_META_FILE + " VK쐬",
                                    "^fBNg쐬Ɏs܂Bf܂B:"
                                            + e3.toString());
                            e3.printStackTrace();
                            return;
                        }

                        InputStream inStream = null;
                        try {
                            URL localURL = BlancoCsvPlugin.getPluginRoot();

                            InputDialog inputDialog = new InputDialog(top
                                    .getShell(), BLANCO_META_FILE + " VK쐬",
                                    BLANCO_META_FILE + "^fBNg["
                                            + comboMetadir.getText()
                                            + "]ɍ쐬܂B" + BLANCO_META_FILE
                                            + "̐VKt@C͂ĂB",
                                    "blancoCsvMeta.xls", new IInputValidator() {
                                        public String isValid(String newText) {
                                            if (newText.endsWith(".xls") == false) {
                                                return "t@C .xlsŏI悤Ɏw肵ĂB";
                                            }
                                            if (BlancoNameUtil
                                                    .isValidFileName(newText) == false) {
                                                return "t@Cɂ "
                                                        + BlancoNameUtil
                                                                .invalidFileNameChar()
                                                        + " ͗pȂłB";
                                            }
                                            // ɂ̃t@C݂Ȃǂ`FbN
                                            IFile newFileMeta = input.getFile()
                                                    .getProject().getFolder(
                                                            comboMetadir
                                                                    .getText())
                                                    .getFile(newText);
                                            if (newFileMeta.exists()) {
                                                return "w̃t@C͊ɑ݂Ă܂B"
                                                        + "ʂ̃t@Cw肵ĂB";
                                            }
                                            return null;
                                        }
                                    });
                            if (inputDialog.open() == InputDialog.CANCEL) {
                                inputDialog.close();
                                return;
                            }
                            final String newMetaFilename = inputDialog
                                    .getValue();
                            inputDialog.close();

                            // vOC̃[Jev[gǂݍ݂܂B
                            inStream = new FileInputStream(
                                    localURL.getPath()
                                            + "/meta/csv/template/blancoCsvTemplate.xls");
                            IFile newFileMeta = input.getFile().getProject()
                                    .getFolder(comboMetadir.getText()).getFile(
                                            newMetaFilename);
                            newFileMeta.create(inStream, true,
                                    getProgressMonitor());
                            MessageDialog
                                    .openInformation(
                                            top.getShell(),
                                            BLANCO_META_FILE + " VK쐬",
                                            BLANCO_META_FILE
                                                    + " ["
                                                    + newMetaFilename
                                                    + "] ^fBNg["
                                                    + comboMetadir.getText()
                                                    + "]ɐVK쐬܂B\n"
                                                    + "̃t@CҏWāACSVt@C֘Aݒ肵ĂB");
                        } catch (CoreException e1) {
                            e1.printStackTrace();
                            return;
                        } catch (IOException e2) {
                            MessageDialog.openWarning(top.getShell(), "^t@C",
                                    "^t@C̃Rs[Ɏs܂B:" + e2.toString());
                            e2.printStackTrace();
                        } finally {
                            if (inStream != null) {
                                try {
                                    inStream.close();
                                } catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }

                    }
                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteJavaSource = new Button(top, SWT.NONE);
        buttonExecuteJavaSource.setText("Java\[XR[h");
        buttonExecuteJavaSource
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboMetadir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "Java\[XR[h", "^fBNg ("
                                                + comboMetadir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            showBusy(true);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteJavaSource.setEnabled(false);

                            String runtimePackage = comboRuntimePackage
                                    .getText();
                            if (runtimePackage.trim().length() == 0) {
                                runtimePackage = null;
                            }
                            String metaDir = comboMetadir.getText();
                            if (metaDir.trim().length() == 0) {
                                metaDir = null;
                            }
                            BlancoCsvGenerateAction.processBlancoCsvJavaSource(
                                    input.getFile(), top.getShell(),
                                    getProgressMonitor(), runtimePackage,
                                    metaDir);

                            // blancotH_𓯊
                            BlancoCsvPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "blanco");

                            // tmptH_𓯊
                            BlancoCsvPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "tmp");

                            // csvtH_𓯊
                            // ܂łیƂē܂B
                            BlancoCsvPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), comboMetadir
                                            .getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(),
                                    "Java\[XR[h", "񕜕s\ȃG[.:"
                                            + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            showBusy(false);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteJavaSource.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteCsSource = new Button(top, SWT.NONE);
        buttonExecuteCsSource.setText("C#.NET\[XR[h");
        buttonExecuteCsSource
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboMetadir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "C#.NET\[XR[h", "^fBNg ("
                                                + comboMetadir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            showBusy(true);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteCsSource.setEnabled(false);

                            String runtimePackage = comboRuntimePackage
                                    .getText();
                            if (runtimePackage.trim().length() == 0) {
                                runtimePackage = null;
                            }
                            String metaDir = comboMetadir.getText();
                            if (metaDir.trim().length() == 0) {
                                metaDir = null;
                            }
                            BlancoCsvGenerateAction.processBlancoCsvCsSource(
                                    input.getFile(), top.getShell(),
                                    getProgressMonitor(), runtimePackage,
                                    metaDir);

                            // blancotH_𓯊
                            BlancoCsvPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "blanco");

                            // tmptH_𓯊
                            BlancoCsvPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "tmp");

                            // csvtH_𓯊
                            // ܂łیƂē܂B
                            BlancoCsvPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), comboMetadir
                                            .getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(),
                                    "C#.NET\[XR[h", "񕜕s\ȃG[.:"
                                            + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            showBusy(false);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteCsSource.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelSettingComment = new Label(top, SWT.NONE);
        labelSettingComment.setText("eX̐ݒl " + TARGET_FILENAME
                + "t@CɕŊi[܂B");
        labelSettingComment
                .setSize(new org.eclipse.swt.graphics.Point(500, 20));

        loadFromTextEditor();

        setFocusLostHandler(comboRuntimePackage);
        setFocusLostHandler(comboMetadir);
    }

    /**
     * ͍ڂ̃`FbN{܂B <br>
     * G[_CAO͂̃\bhŕ\܂B
     * 
     * @return
     */
    private final boolean checkInputField() {
        boolean isError = false;
        if (comboMetadir.getText().length() == 0) {
            comboMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (isError) {
            MessageDialog.openWarning(top.getShell(), "K{ڂւ̓͂܂",
                    "K{ڂւ̓͂܂B\nnCCg\ĂK{ڂɒl͂Ă");
        }

        return !isError;
    }

    /**
     * This method initializes comboMetadir
     * 
     */
    private void createComboMetadir() {
        comboMetadir = new Combo(top, SWT.NONE);
        comboMetadir.add("meta/csv");
        comboMetadir.select(0);
    }

    /**
     * This method initializes comboMetadir
     * 
     */
    private void createComboRuntimePackage() {
        comboRuntimePackage = new Combo(top, SWT.NONE);
        comboRuntimePackage.add("myapp.csv");
    }

    protected void loadFromTextEditorInternal(final DOMResult argResult) {
        final Node nodeRoot = argResult.getNode();
        if (nodeRoot == null) {
            return;
        }

        final Element elementBlancoDb = BlancoXmlUtil.getElement(nodeRoot,
                "blanco/target/blancocsv");
        if (elementBlancoDb == null) {
            return;
        }

        final String runtimePackage = elementBlancoDb
                .getAttribute("runtimepackage");
        if (runtimePackage != null) {
            comboRuntimePackage.setText(runtimePackage);
        }

        final String metadir = elementBlancoDb.getAttribute("metadir");
        if (metadir != null) {
            comboMetadir.setText(metadir);
        }
    }

    protected Document saveToTextEditorInternal() {
        String runtimepackage = null;
        if (comboRuntimePackage.getText().trim().length() > 0) {
            runtimepackage = comboRuntimePackage.getText();
        }

        String metadir = null;
        if (comboMetadir.getText().trim().length() > 0) {
            metadir = comboMetadir.getText();
        }

        final Document document = BlancoXmlUtil.newDocument();
        final Element eleBlanco = document.createElement("blanco");
        document.appendChild(eleBlanco);

        final Element eleTarget = document.createElement("target");
        eleTarget.setAttribute("name", textBlancoCsvSettingId.getText());
        eleBlanco.appendChild(eleTarget);

        final Element eleBlancoCsv = document.createElement("blancocsv");
        eleTarget.appendChild(eleBlancoCsv);

        if (runtimepackage != null) {
            eleBlancoCsv.setAttribute("runtimepackage", runtimepackage);
        }

        if (metadir != null) {
            eleBlancoCsv.setAttribute("metadir", metadir);
        }

        return document;
    }
}