/*
 * blanco Framework Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.uno;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;

import blanco.report.resourcebundle.BlancoUnoResourceBundle;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.BridgeExistsException;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;

/**
 * UNOC^tF[X𗘗pۂ̋ʓIȏS܂B<br>
 * ̓Iɂ UNOoRt@C̓ǂݍ݂ƏoS܂B<br>
 * ̃C^tF[Xs邽߂ɂ OpenOffice.org 2.0ȍ~KvłB
 * 
 * @author IGA Tosiki
 */
public class BlancoUnoInstance {
    private final BlancoUnoResourceBundle bundle = new BlancoUnoResourceBundle();

    /**
     * UNOڑŗp\PbgRlNV
     */
    protected XConnection fConnection = null;

    /**
     * ǂݍ܂ꂽR|[lg
     */
    protected XComponent fComponent = null;

    /**
     * fobO[hœ삷邩ǂtO
     */
    private static final boolean IS_DEBUG = false;

    /**
     * UNOڑ̐ڑgCő
     */
    private int fConnectRetryMaxCount = 30;

    /**
     * UNOڑ̐ڑgCȂۂɑҋ@b
     */
    private int fConnectRetryWaitSecond = 1;

    /**
     * RlNVm̍ő僊gC񐔂ݒ肵܂B
     * 
     * @param arg
     *            ő僊gC񐔁B
     */
    public void setConnectRetryMaxCount(final int arg) {
        fConnectRetryMaxCount = arg;
    }

    public void setConnectRetryWaitSecond(final int arg) {
        fConnectRetryWaitSecond = arg;
    }

    /**
     * w肳ꂽt@C[h܂B
     * 
     * @param fileSource
     *            [h̓t@C
     * @param isShowOpenOfficeWindow
     *            ϊOpenOffice.org̃EChE\邩ǂ
     * @throws IllegalArgumentException
     *             ǂݍݎɔeO
     */
    public void load(final File fileSource, final boolean isShowOpenOfficeWindow)
            throws IllegalArgumentException {
        if (fConnection != null) {
            throw new IllegalArgumentException("UNOڑɊmĂ܂B𒆒f܂B");
        }
        if (fComponent != null) {
            throw new IllegalArgumentException(
                    "UNOڑ̃R|[lgCX^Xɑ݂Ă܂B𒆒f܂B");
        }
        if (fileSource.exists() == false) {
            throw new IllegalArgumentException("̓t@C["
                    + fileSource.getAbsolutePath() + "]܂Bf܂B");
        }

        // ǂݍ݂̂߂̑Os܂B
        final XBridge bridge = createBridgeConnection(bundle
                .getUnoConnectionString());
        final Object desktop = createLocalDesktopInstance(bridge);
        final XComponentLoader componentLoader = (XComponentLoader) UnoRuntime
                .queryInterface(XComponentLoader.class, desktop);

        // hLgۂɃ[h܂B
        final PropertyValue[] loadProps = new PropertyValue[1];
        loadProps[0] = new PropertyValue();
        loadProps[0].Name = "Hidden";
        loadProps[0].Value = new Boolean(!isShowOpenOfficeWindow);
        try {
            fComponent = componentLoader.loadComponentFromURL(
                    file2url(fileSource), "_blank", 0, loadProps);
        } catch (com.sun.star.io.IOException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficet@C[h: [h̍ۂɓo͗O܂.:" + ex.toString());
        } catch (com.sun.star.lang.IllegalArgumentException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficet@C[h: [h̍ۂɕsȓ͂^܂.:"
                            + ex.toString());
        }
    }

    /**
     * ۑ܂B
     * 
     * @param filterName
     *            "StarOffice XML (Calc)" Ȃǂw
     * @param fileTarget
     * @throws MalformedURLException
     * @throws IOException
     * @throws com.sun.star.io.IOException
     * @throws IllegalArgumentException
     */
    public void save(final String filterName, final File fileTarget) {
        if (fConnection == null) {
            throw new IllegalArgumentException("UNOڑmĂ܂B𒆒f܂B");
        }
        if (fComponent == null) {
            throw new IllegalArgumentException(
                    "UNOڑ̃R|[lgCX^X݂Ă܂B𒆒f܂B");
        }
        if (fileTarget.exists()) {
            if (fileTarget.delete() == false) {
                throw new IllegalArgumentException("o̓t@C["
                        + fileTarget.getAbsolutePath()
                        + "]݂̂ŏɐ旧폜悤Ƃ܂폜Ɏs܂Bf܂B");
            }
        }

        // ۑ̂߂̑Os܂B
        final XStorable storable = (XStorable) UnoRuntime.queryInterface(
                XStorable.class, fComponent);

        // ۂ̕ۑs܂B
        final PropertyValue[] saveProps = new PropertyValue[1];
        saveProps[0] = new PropertyValue();
        saveProps[0].Name = "FilterName";
        saveProps[0].Value = filterName;
        try {
            storable.storeToURL(file2url(fileTarget), saveProps);
        } catch (com.sun.star.io.IOException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficet@CZ[u: Z[u̍ۂɓo͗O܂.:" + ex.toString());
        }

        // R|[lgj܂B
        fComponent.dispose();
        fComponent = null;

        // UNOڑN[Y܂B
        try {
            fConnection.close();
            fConnection = null;
        } catch (com.sun.star.io.IOException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficet@CZ[u: RlNVN[Y̍ۂɓo͗O܂.:"
                            + ex.toString());
        }

        if (IS_DEBUG) {
            System.out.println("ExcelubNVK쐬ăt@Cۑ̈ȀI܂.");
        }
    }

    // ͓Iɗp郁\bh

    /**
     * FileURLɕϊ܂B<br>
     * ȂAUNO [file:///] n܂URLłȂ̂ŁA̖OɂĒs܂B
     * 
     * @param fileTarget
     *            ϊFileIuWFNg
     * @return ϊURL
     */
    private static final String file2url(final File fileTarget) {
        try {
            String url = fileTarget.getCanonicalFile().toURL().toString();
            if (url.indexOf("file:///") >= 0) {
                return url;
            }
            url = url.replaceAll("file:/", "file:///");
            if (url.startsWith("file:///") == false) {
                throw new IllegalArgumentException("FileURLւ̕ϊŕsURL["
                        + url + "]܂B");
            }
            return url;
        } catch (MalformedURLException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficet@CZ[u: sURL^܂.:" + ex.toString());
        } catch (IOException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficet@CZ[u: URL̍ۂɓo͗O܂.:" + ex.toString());
        }
    }

    /**
     * OpenOfficւ̃ubWڑ(UNOڑ)I[v܂
     * 
     * @param connectionString
     *            ڑ
     * @return ubWڑ
     * @throws IllegalArgumentException
     */
    protected XBridge createBridgeConnection(final String connectionString)
            throws IllegalArgumentException {
        if (IS_DEBUG) {
            System.out.println("OpenOfficւ̃ubWڑ(UNOڑ)I[v܂.");
        }
        final XComponentContext localContext;
        try {
            localContext = Bootstrap.createInitialComponentContext(null);
        } catch (Exception ex) {
            throw new IllegalArgumentException(
                    "OpenOfficeubW쐬: R|[lgReLXg쐬ɂėO܂.:"
                            + ex.toString());
        }
        final XMultiComponentFactory localServiceManager = localContext
                .getServiceManager();
        XConnector connector = null;
        try {
            connector = (XConnector) UnoRuntime.queryInterface(
                    XConnector.class, localServiceManager
                            .createInstanceWithContext(
                                    "com.sun.star.connection.Connector",
                                    localContext));
        } catch (Exception ex) {
            throw new IllegalArgumentException(
                    "OpenOfficeubW쐬: RlN^[쐬ɂėO܂.:" + ex.toString());
        }

        // UNOڑ̂̂Jn܂B
        //  UNOڑ̊jƂȂ镔łB
        connectUno(connectionString, connector);

        // [gڑ̂߂̃ubW擾܂B
        XBridgeFactory bridgeFactory = null;
        try {
            bridgeFactory = (XBridgeFactory) UnoRuntime.queryInterface(
                    XBridgeFactory.class, localServiceManager
                            .createInstanceWithContext(
                                    "com.sun.star.bridge.BridgeFactory",
                                    localContext));
        } catch (Exception ex) {
            throw new IllegalArgumentException(
                    "OpenOfficeubW쐬: ubWt@Ng擾ɗO܂.:"
                            + ex.toString());
        }
        try {
            return bridgeFactory.createBridge("", "urp", fConnection, null);
        } catch (BridgeExistsException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficeubW쐬: ubWɑ݂ƂO܂.:"
                            + ex.toString());
        } catch (com.sun.star.lang.IllegalArgumentException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficeubW쐬: s̗O܂.:" + ex.toString());
        }
    }

    /**
     * UNOڑ̂̂Jn܂B
     * 
     *  UNOڑ̊jƂȂ镔łB
     * 
     * @param connectionString
     *            ڑB
     * @param connector
     *            RlN^B
     * @throws IllegalArgumentException
     *             UNOڑɎsꍇȂ
     */
    private void connectUno(final String connectionString, XConnector connector) {
        try {
            for (int retryCount = 1;; retryCount++) {
                try {
                    fConnection = connector.connect(connectionString);
                } catch (NoConnectException ex) {
                    if (retryCount > fConnectRetryMaxCount) {
                        // ő僊gCɓBĂ܂ꍇ͗OX[܂B
                        throw new IllegalArgumentException(
                                "OpenOffice UNOڑJn: RlNV擾ɗO܂B("
                                        + connectionString
                                        + ") ̃\Pbg|[gԍɂT|[gtOpenOffice.orgNĂȂƂl܂B:"
                                        + ex.toString());
                    } else {
                        // ēxڑ݂܂B
                        System.out.println("UNOڑ̊mɎs܂Bēxڑ݂܂B("
                                + retryCount + "/" + fConnectRetryMaxCount
                                + ")");
                        Thread.sleep(fConnectRetryWaitSecond * 1000);
                        continue;
                    }
                }
                // ڑ܂B[v𗣒E܂B
                break;
            }
        } catch (InterruptedException ex) {
            throw new IllegalArgumentException(
                    "OpenOffice UNOڑJn: RlNV擾̑ҋ@Ɋ荞݂܂B:"
                            + ex.toString());
        } catch (ConnectionSetupException ex) {
            throw new IllegalArgumentException(
                    "OpenOffice UNOڑJn: RlNVZbgAbvɗO܂.:"
                            + ex.toString());
        }
    }

    /**
     * OpenOffice[JfXNgbvCX^X쐬܂.<br>
     * ̃\bhUNORlNVڑɎs܂B
     * 
     * @param bridge
     *            ubWڑ
     * @return [JfXNgbvIuWFNg
     * @throws IllegalArgumentException
     */
    protected static Object createLocalDesktopInstance(final XBridge bridge)
            throws IllegalArgumentException {
        if (IS_DEBUG) {
            System.out.println("OpenOfficẽfXNgbvCX^X쐬܂.");
        }

        final XMultiComponentFactory serviceManager = (XMultiComponentFactory) UnoRuntime
                .queryInterface(XMultiComponentFactory.class, bridge
                        .getInstance("StarOffice.ServiceManager"));
        final XPropertySet propertySet = (XPropertySet) UnoRuntime
                .queryInterface(XPropertySet.class, serviceManager);
        XComponentContext remoteContext = null;
        try {
            remoteContext = (XComponentContext) UnoRuntime.queryInterface(
                    XComponentContext.class, propertySet
                            .getPropertyValue("DefaultContext"));
        } catch (UnknownPropertyException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficefXNgbvCX^X쐬: DefaultContextC^tF[X擾̍ۂɃvpeBs̗O܂.:"
                            + ex.toString());
        } catch (WrappedTargetException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficefXNgbvCX^X쐬; DefaultContextC^tF[X擾̍ۂɃbvꂽO܂.:"
                            + ex.toString() + ": " + ex.getCause().toString());
        }
        final XMultiComponentFactory remoteServiceManager = remoteContext
                .getServiceManager();
        try {
            return remoteServiceManager.createInstanceWithContext(
                    "com.sun.star.frame.Desktop", remoteContext);
        } catch (Exception ex) {
            throw new IllegalArgumentException(
                    "OpenOfficefXNgbvCX^X쐬: ReLXgtCX^X쐬ɂėO܂.:"
                            + ex.toString());
        }
    }
}
