/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.js;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;

import blanco.cg.transformer.AbstractBlancoCgJavaStyleTransformer;
import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * blancoCg̃o[IuWFNg\[XR[hgXtH[}[̃Gg|CgłB
 * 
 * BlancoCgTransformerFactoryoRĐ邱Ƃ𐄏܂B<br>
 * ̃gXtH[}[ł̓o[IuWFNgJavaScript\[XR[hւƕϊ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoCgJsSourceTransformer extends
        AbstractBlancoCgJavaStyleTransformer {

    /**
     * \[Xt@CEo[IuWFNgJavaScript\[XR[hɕϊăC^[ɏo͂܂B
     * 
     * APIł̓pbP[W\fBNg\Ƃ͍l܂B̏̒ł̓C^[Ɍďo͂邾łB
     * 
     * @param argSourceFile
     *            \[Xt@CEo[IuWFNgB
     * @param writer
     *            o͐̃C^[B
     * @throws o͗OꍇB
     */
    public void transform(final BlancoCgSourceFile argSourceFile,
            final BufferedWriter argWriter) throws IOException {
        if (argSourceFile == null) {
            throw new IllegalArgumentException("\[Xt@Cnull^܂Bf܂B");
        }
        if (argWriter == null) {
            throw new IllegalArgumentException("o͐惉C^[null^܂Bf܂B");
        }

        final ArrayList sourceLines = new BlancoCgSourceFileJsSourceExpander()
                .transformSourceFile(argSourceFile);

        // \[XR[h𐮌`܂B
        formatSource(sourceLines);

        // \[XR[hC^ւƏo͂܂B
        source2Writer(sourceLines, argWriter);
    }

    /**
     * \[XR[hɕtgq擾܂B
     * 
     * @return \[XR[hɕtgqB
     */
    protected String getSourceFileExt() {
        return ".js";
    }
}
