/*
 * blancoDb
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import blanco.db.definition.QueryIterator;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * J[\truȅꍇɁÃ\bh͍쐬܂B
 * 
 * @author Tosiki Iga
 */
public class RelativeMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    private QueryIterator _iterator = null;

    public RelativeMethod(final BlancoDbObjectStorage storage,
            final QueryIterator iterator) {
        super("relative");
        this.storage = storage;
        this._iterator = iterator;
    }

    /**
     * VOLłꍇɂ protectedƂ܂B
     */
    protected Scope getScope() {
        if (_iterator.isSingle()) {
            return Scope.PROTECTED;
        } else {
            return Scope.PUBLIC;
        }
    }

    public void setupSignature() {
        setReturnType(new Type(boolean.class));

        // ^CpbP[W̕ωɑΉB
        String runtimePackage = storage.getSetting().getRootNameSpace();
        if (storage.getSetting().getRuntimePackage() != null) {
            runtimePackage = storage.getSetting().getRuntimePackage();
        }

        final Type deadlockException = new Type(runtimePackage
                + ".exception.DeadlockException");
        getJavaDoc().addException(deadlockException, "f[^x[XfbhbNꍇB");
        addException(deadlockException);

        final Type timeoutException = new Type(runtimePackage
                + ".exception.TimeoutException");
        getJavaDoc().addException(timeoutException, "f[^x[X^CAEgꍇB");
        addException(timeoutException);

        getJavaDoc().addException(new Type("java.sql.SQLException"),
                "SQLOꍇB");
        addException(new Type("java.sql.SQLException"));

        getJavaDoc().addParameter("rows",
                "݂̍sړ鑊΍sw肵܂B̐ł̓J[\ɈړA̐ł̓J[\tɈړ܂B");
        addArgument(new Value(int.class, "rows"));

        getJavaDoc().addLine("J[\ʃZbg̑΍sړ܂B");
        getJavaDoc().addLine("");
        if (_iterator.isSingle()) {
            getJavaDoc().addLine("VOLȂ̂ŃXR[vprotectedƂ܂B<br>");
        }
        getJavaDoc().addLine("relative(1)next()ĂяôƓłB<br>");
        getJavaDoc().addLine("relative(-1)previous()ĂяôƓłB<br>");
        getJavaDoc().addReturn("V݂̍sLȏꍇtrueAȏ̍sȂꍇfalseB");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName()
                    + ": rows = \" + rows);");
            implementor.addLine("}");
            implementor.addLine("");
        }

        // resultSetmۂł΂AIexecuteQueryĂяo܂B
        implementor.addLine("if (fResultSet == null) {");
        implementor.addStatement("executeQuery()");
        implementor.addLine("}");

        implementor.addLine("");
        implementor.addLine("try {");
        implementor.addLine("return fResultSet.relative(rows);");
        implementor.addLine("} catch (SQLException ex) {");
        implementor.addLine("throw BlancoDbUtil.convertToBlancoException(ex);");
        implementor.addLine("}");
    }
}