/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.sax.task;

import java.io.File;
import java.io.IOException;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.sax.BlancoSaxXml2Handler;
import blanco.sax.BlancoSaxXml2HandlerTest;
import blanco.sax.BlancoSaxXml2Serializer;
import blanco.sax.BlancoSaxXml2SerializerTest;

public class BlancoConcreteSaxTask extends AbstractBlancoConcreteSaxTask {
    protected void process() throws IllegalArgumentException {
        final File metaDir = new File(getMetadir());
        if (metaDir.exists() == false) {
            throw new IllegalArgumentException("^fBNg[" + getMetadir()
                    + "]݂܂B");
        }
        if (metaDir.isDirectory() == false) {
            throw new IllegalArgumentException("^fBNg[" + getMetadir()
                    + "]̓fBNgł͂܂B");
        }

        final File targetDir = new File(getTargetdir());
        targetDir.mkdirs();
        final File targetBlancoMain = new File(getTargetdir() + "/main");
        targetBlancoMain.mkdirs();

        final File[] fileMeta = metaDir.listFiles();
        for (int index = 0; index < fileMeta.length; index++) {
            final File fileLook = fileMeta[index];
            if (fileLook.getName().endsWith(".xml") == false) {
                // gqxmlȊÕt@C̓XLbv܂B
                continue;
            }
            final String fileName = BlancoNameUtil.trimFileExtension(fileLook
                    .getName());

            try {
                new BlancoSaxXml2Handler().process(fileLook, targetDir
                        .getAbsolutePath(), getBasePackage(),
                        BlancoNameAdjuster.toClassName(fileName) + "Handler");
                new BlancoSaxXml2Serializer()
                        .process(fileLook, targetDir.getAbsolutePath(),
                                getBasePackage(), BlancoNameAdjuster
                                        .toClassName(fileName)
                                        + "Serializer");
                // eXgNX܂B
                new BlancoSaxXml2HandlerTest().process(fileLook, targetDir
                        .getAbsolutePath(), getBasePackage(),
                        BlancoNameAdjuster.toClassName(fileName) + "Handler");
                new BlancoSaxXml2SerializerTest()
                        .process(fileLook, targetDir.getAbsolutePath(),
                                getBasePackage(), BlancoNameAdjuster
                                        .toClassName(fileName)
                                        + "Serializer");
            } catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("t@C[" + fileLook.getName()
                        + "]̏ɃG[܂B𒆒f܂B\n\n" + e.toString());
            } catch (IOException e) {
                throw new IllegalArgumentException("t@C[" + fileLook.getName()
                        + "]̏ɃG[܂B𒆒f܂B\n\n" + e.toString());
            }
        }
    }
}
