/*
 * blanco Framework Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.soap.dotnet.wsdl2cs;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.IgStatement;
import blanco.ig.expander.method.MethodExpander;
import blanco.soap.dotnet.wsdl2cs.resourcebundle.BlancoSoapDotNetWsdl2CsResourceBundle;
import blanco.wsdl.valueobject.BlancoWsdlWebService;
import blanco.wsdl.valueobject.BlancoWsdlWebServiceOperation;

public class BlancoSoapDotnetWsdl2CsExpandTelegramProcessorProxy extends
        ClassExpander {
    private BlancoWsdlWebService fWsdl = null;

    private final BlancoSoapDotNetWsdl2CsResourceBundle bundle = new BlancoSoapDotNetWsdl2CsResourceBundle();

    public BlancoSoapDotnetWsdl2CsExpandTelegramProcessorProxy(
            final IgType type, final BlancoWsdlWebService wsdl) {
        super(type);
        this.fWsdl = wsdl;
    }

    protected void expandClassStruct() {
        final String superClassName = fWsdl.getPackage() + "."
                + fWsdl.getWebServiceId();
        setSuperClass(new IgType(superClassName));
        getCgClass().getAnnotationList().add(
                "WebService(Namespace=\"" + fWsdl.getNamespace() + "\")");

        addFileComment("̃NX blancoɂ莩Ă܂B");
        getJavaDoc().addLine("̃NXWebT[rXdւ̃vLVNXłB");
        getJavaDoc().addLine(
                ".NET Framework SDK  wsdl.exe WebT[rX["
                        + fWsdl.getWebServiceId() + "]̒ۃNX[" + superClassName
                        + "]pĂ܂B");

        addImport(new IgType("System.Exception"));
        addImport(new IgType("System.Web.Services.WebService"));

        if (BlancoStringUtil.null2Blank(bundle.getDbConnUsing01()).trim()
                .length() > 0) {
            addImport(new IgType(bundle.getDbConnUsing01()));
        }
        if (BlancoStringUtil.null2Blank(bundle.getDbConnUsing02()).trim()
                .length() > 0) {
            addImport(new IgType(bundle.getDbConnUsing02()));
        }
        if (BlancoStringUtil.null2Blank(bundle.getDbConnUsing03()).trim()
                .length() > 0) {
            addImport(new IgType(bundle.getDbConnUsing03()));
        }
        if (BlancoStringUtil.null2Blank(bundle.getDbConnUsing04()).trim()
                .length() > 0) {
            addImport(new IgType(bundle.getDbConnUsing04()));
        }
        if (BlancoStringUtil.null2Blank(bundle.getDbConnUsing05()).trim()
                .length() > 0) {
            addImport(new IgType(bundle.getDbConnUsing05()));
        }

        final FieldExpander fieldLog = new FieldExpander(new IgType(
                "log4net.ILog"), "fLog") {
            protected boolean isStatic() {
                return false;
            }
        };
        fieldLog.setDefaultStatement(new IgStatement(
                "LogManager.GetLogger(\"Server\")"));
        fieldLog.getJavaDoc().addLine("log4net̃IuWFNg̃CX^XB");
        fieldLog.getJavaDoc()
                .addLine("ƗێړI邽߂ɁAlog4netAPI𒼐ڌĂяoĂ܂B");
        addField(fieldLog);

        for (int indexOperation = 0; indexOperation < fWsdl.getOperationList()
                .size(); indexOperation++) {
            final BlancoWsdlWebServiceOperation operation = (BlancoWsdlWebServiceOperation) fWsdl
                    .getOperationList().get(indexOperation);

            addMethod(new MethodExpander(operation.getName()) {
                public void setupSignature() {
                    getCgMethod().getAnnotationList().add("WebMethod");
                    getCgMethod().setOverride(true);

                    setReturnType(new IgType(operation.getOutput()
                            .getPackageOfJava(), operation.getOutput()
                            .getName()));
                    addArgument(new IgValue(
                            new IgType(operation.getInput().getPackageOfJava(),
                                    operation.getInput().getName()), "input"));

                    getJavaDoc().addLine("̃\bhWebT[rX̃\bhłB");
                }

                public void implement() {
                    getData()
                            .addLine(
                                    operation.getOutput().getName()
                                            + " output = null;");

                    getData().addLine("// f[^x[Xڑ擾܂B");
                    getData().addLine(
                            "System.Data.SqlClient.SqlConnection conn = null;");
                    getData()
                            .addLine(
                                    "System.Data.SqlClient.SqlTransaction tran = null;");
                    getData().addLine("try ");
                    getData().addLine("{");
                    getData().addLine("// f[^x[XڑJn܂B");
                    if (BlancoStringUtil
                            .null2Blank(bundle.getDbConnConnect01()).length() > 0) {
                        getData().addLine(bundle.getDbConnConnect01());
                    }
                    if (BlancoStringUtil
                            .null2Blank(bundle.getDbConnConnect02()).length() > 0) {
                        getData().addLine(bundle.getDbConnConnect02());
                    }
                    if (BlancoStringUtil
                            .null2Blank(bundle.getDbConnConnect03()).length() > 0) {
                        getData().addLine(bundle.getDbConnConnect03());
                    }
                    if (BlancoStringUtil
                            .null2Blank(bundle.getDbConnConnect04()).length() > 0) {
                        getData().addLine(bundle.getDbConnConnect04());
                    }
                    if (BlancoStringUtil
                            .null2Blank(bundle.getDbConnConnect05()).length() > 0) {
                        getData().addLine(bundle.getDbConnConnect05());
                    }
                    getData().addLine("tran = conn.BeginTransaction();");
                    getData().addLine("");
                    getData().addLine("// ۂ̏Ăяo܂B");
                    getData()
                            .addLine(
                                    "Abstract"
                                            + BlancoNameAdjuster
                                                    .toClassName(operation
                                                            .getName())
                                            + "TelegramProcessor telegramProcessor = new "
                                            + BlancoNameAdjuster
                                                    .toClassName(operation
                                                            .getName())
                                            + "TelegramProcessor();");
                    getData().addLine("telegramProcessor.SetConnection(conn);");
                    getData()
                            .addLine("telegramProcessor.SetTransaction(tran);");
                    getData().addLine(
                            "output = telegramProcessor.Execute(input);");
                    getData().addLine("");
                    getData().addLine(
                            "// dƂă[obNtOĂȂꍇɂ̂݃R~bgȂ܂B");
                    getData().addLine(
                            "if (telegramProcessor.GetRollback() == false)");
                    getData().addLine("{");
                    getData().addLine("tran.Commit();");
                    getData().addLine("// R~bg𔭍ŝŁAnullZbgď܂B");
                    getData().addLine("tran = null;");
                    getData().addLine("}");
                    getData().addLine("");
                    getData().addLine("return output;");
                    getData().addLine("}");

                    // System.Data.SqlClient.SqlException Lb`
                    getData().addLine(
                            "catch(System.Data.SqlClient.SqlException ex)");
                    getData().addLine("{");
                    getData().addLine("//Console.WriteLine(ex.ToString());");
                    getData().addLine("// MOs܂B");
                    getData().addLine(
                            "fLog.Fatal(\"SQLO܂B\" + ex.ToString());");
                    getData().addLine("// OIuWFNǵÂ܂܃X[܂B");
                    getData().addLine("throw ex;");
                    getData().addLine("}");

                    // SoapException Lb`
                    addUsingType(new IgType(
                            "System.Web.Services.Protocols.SoapException"));
                    getData().addLine("catch(SoapException ex)");
                    getData().addLine("{");
                    getData().addLine("//Console.WriteLine(ex.ToString());");
                    getData().addLine("// MOs܂B");
                    getData()
                            .addLine(
                                    "fLog.Fatal(\"WebT[rXO܂B\" + ex.ToString());");
                    getData().addLine("// OIuWFNǵÂ܂܃X[܂B");
                    getData().addLine("throw ex;");
                    getData().addLine("}");

                    // System.SystemException Lb`
                    getData().addLine("catch(System.SystemException ex)");
                    getData().addLine("{");
                    getData().addLine("//Console.WriteLine(ex.ToString());");
                    getData().addLine("// MOs܂B");
                    getData()
                            .addLine(
                                    "fLog.Fatal(\"System.SystemException܂B\" + ex.ToString());");
                    getData().addLine("// OIuWFNǵÂ܂܃X[܂B");
                    getData().addLine("throw ex;");
                    getData().addLine("}");

                    // System.Exception Lb`
                    getData().addLine("catch(System.Exception ex)");
                    getData().addLine("{");
                    getData().addLine("//Console.WriteLine(ex.ToString());");
                    getData().addLine("// MOs܂B");
                    getData()
                            .addLine(
                                    "fLog.Fatal(\"System.Exception܂B\" + ex.ToString());");
                    getData().addLine("// OIuWFNǵÂ܂܃X[܂B");
                    getData().addLine("throw ex;");
                    getData().addLine("}");

                    getData().addLine("finally");
                    getData().addLine("{");
                    getData().addLine("try");
                    getData().addLine("{");
                    getData().addLine("if(tran != null)");
                    getData().addLine("{");
                    getData().addLine(
                            "// gUNVIuWFNgAR~bg̏ꍇɂ̂݃[obN܂B");
                    getData()
                            .addLine(
                                    "// ADO.NETŃR~bgɃ[obNƗO邽 ̂悤ɂĂ܂B");
                    getData().addLine("tran.Rollback();");
                    getData().addLine("}");
                    getData().addLine("}");
                    getData().addLine("finally");
                    getData().addLine("{");
                    getData().addLine("if(conn != null)");
                    getData().addLine("{");
                    getData().addLine("// f[^x[XڑI܂B");
                    if (BlancoStringUtil.null2Blank(bundle.getDbConnClose01())
                            .length() > 0) {
                        getData().addLine(bundle.getDbConnClose01());
                    }
                    if (BlancoStringUtil.null2Blank(bundle.getDbConnClose02())
                            .length() > 0) {
                        getData().addLine(bundle.getDbConnClose02());
                    }
                    if (BlancoStringUtil.null2Blank(bundle.getDbConnClose03())
                            .length() > 0) {
                        getData().addLine(bundle.getDbConnClose03());
                    }
                    if (BlancoStringUtil.null2Blank(bundle.getDbConnClose04())
                            .length() > 0) {
                        getData().addLine(bundle.getDbConnClose04());
                    }
                    if (BlancoStringUtil.null2Blank(bundle.getDbConnClose05())
                            .length() > 0) {
                        getData().addLine(bundle.getDbConnClose05());
                    }
                    getData().addLine("}");
                    getData().addLine("}");
                    getData().addLine("}");
                }
            });
        }
    }
}
