/*
 * blanco Framework Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.soap.dotnet.wsdl2cs.client;

import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.IgStatement;
import blanco.ig.expander.method.MethodExpander;
import blanco.soap.dotnet.wsdl2cs.resourcebundle.BlancoSoapDotNetWsdl2CsResourceBundle;
import blanco.wsdl.valueobject.BlancoWsdlWebService;
import blanco.wsdl.valueobject.BlancoWsdlWebServiceOperation;

/**
 * NCAg̓dNXB
 * 
 * @author IGA Tosiki
 */
public class BlancoSoapDotnetWsdl2CsExpandTelegramProcessorClient extends
        ClassExpander {
    private BlancoWsdlWebService fWsdl = null;

    private final BlancoSoapDotNetWsdl2CsResourceBundle bundle = new BlancoSoapDotNetWsdl2CsResourceBundle();

    /**
     * ^[QbgWebT[rXID
     */
    private String targetServiceName;

    public BlancoSoapDotnetWsdl2CsExpandTelegramProcessorClient(
            final IgType type, final BlancoWsdlWebService wsdl) {
        super(type);
        this.fWsdl = wsdl;
    }

    protected void expandClassStruct() {
        // T[rXm肳܂B"Service" WebT[rXID𗘗pĂ܂B
        targetServiceName = fWsdl.getWebServiceId().substring(0,
                fWsdl.getWebServiceId().length() - "Service".length());

        addFileComment("̃NX blancoɂ莩Ă܂B");
        getJavaDoc().addLine("̃NX̓NCAgWebT[rX̓dĂяoۂ̃vLVNXłB");
        getJavaDoc().addLine(
                ".NET Framework SDK  wsdl.exe WebT[rX["
                        + targetServiceName + "]̃NXŌĂяo܂B");

        addImport(new IgType("System.Exception"));
        addImport(new IgType("System.Web.Services.WebService"));

        final FieldExpander fieldLog = new FieldExpander(new IgType(
                "log4net.ILog"), "fLog") {
            protected boolean isStatic() {
                return false;
            }
        };
        fieldLog.setDefaultStatement(new IgStatement(
                "LogManager.GetLogger(\"Client\")"));
        fieldLog.getJavaDoc().addLine("log4net̃IuWFNg̃CX^XB");
        fieldLog.getJavaDoc()
                .addLine("ƗێړI邽߂ɁAlog4netAPI𒼐ڌĂяoĂ܂B");
        addField(fieldLog);

        for (int indexOperation = 0; indexOperation < fWsdl.getOperationList()
                .size(); indexOperation++) {
            final BlancoWsdlWebServiceOperation operation = (BlancoWsdlWebServiceOperation) fWsdl
                    .getOperationList().get(indexOperation);

            addMethod(new MethodExpander(operation.getName()) {
                public void setupSignature() {
                    setReturnType(new IgType(operation.getOutput()
                            .getPackageOfJava(), operation.getOutput()
                            .getName()));
                    addArgument(new IgValue(
                            new IgType(operation.getInput().getPackageOfJava(),
                                    operation.getInput().getName()), "input"));

                    getJavaDoc().addLine("̃\bhWebT[rX̃\bhłB");
                }

                public void implement() {
                    getData()
                            .addLine(
                                    fWsdl.getWebServiceId()
                                            + "TelegramProcessProxy telegramProcessorProxy = new "
                                            + fWsdl.getWebServiceId()
                                            + "TelegramProcessProxy();");
                    if (bundle.getWsClientUrlIp().length() > 0) {
                        // IPAhX擾O\[X擾܂B
                        // {̓P[Vû]܂ƂlB
                        getData().addLine(
                                "// WebT[rX[" + targetServiceName
                                        + "]Ƃ̂ŎQƂKv܂B");
                        getData().addLine(
                                "telegramProcessorProxy.Url = \"http://\" + "
                                        + bundle.getWsClientUrlIp() + " + \""
                                        + bundle.getWsClientUrlSubdir()
                                        + targetServiceName + ".asmx\";");
                    }
                    getData()
                            .addLine(
                                    operation.getOutput().getName()
                                            + " output = null;");

                    getData().addLine("");
                    if (bundle.getWsClientUsing01().length() > 0) {
                        addUsingType(new IgType(replaceKeyword(bundle
                                .getWsClientUsing01(), operation)));

                    }
                    if (bundle.getWsClientUsing02().length() > 0) {
                        addUsingType(new IgType(replaceKeyword(bundle
                                .getWsClientUsing02(), operation)));

                    }
                    if (bundle.getWsClientUsing03().length() > 0) {
                        addUsingType(new IgType(replaceKeyword(bundle
                                .getWsClientUsing03(), operation)));

                    }
                    if (bundle.getWsClientUsing04().length() > 0) {
                        addUsingType(new IgType(replaceKeyword(bundle
                                .getWsClientUsing04(), operation)));

                    }
                    if (bundle.getWsClientUsing05().length() > 0) {
                        addUsingType(new IgType(replaceKeyword(bundle
                                .getWsClientUsing05(), operation)));

                    }

                    if (bundle.getWsClientBegin01().length() > 0) {
                        getData().addLine("// vd̋ʕZbg܂B");
                        if (bundle.getWsClientBegin01().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin01(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin02().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin02(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin03().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin03(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin04().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin04(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin05().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin05(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin06().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin06(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin07().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin07(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin08().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin08(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin09().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin09(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin10().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin10(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin11().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin11(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin12().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin12(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin13().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin13(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin14().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin14(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin15().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin15(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin16().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin16(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin17().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin17(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin18().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin18(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin19().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin19(),
                                            operation));
                        }
                        if (bundle.getWsClientBegin20().length() > 0) {
                            getData().addLine(
                                    replaceKeyword(bundle.getWsClientBegin20(),
                                            operation));
                        }
                    }

                    getData().addLine("");
                    getData().addLine("// ۂ̏Ăяo܂B");
                    getData().addLine("try");
                    getData().addLine("{");
                    getData().addLine(
                            "output = telegramProcessorProxy."
                                    + operation.getName() + "(input);");
                    getData().addLine("return output;");
                    getData().addLine("}");

                    // SoapException Lb`
                    addUsingType(new IgType(
                            "System.Web.Services.Protocols.SoapException"));
                    getData().addLine("catch(SoapException ex)");
                    getData().addLine("{");
                    getData().addLine("// SoapExceptionʂɊ荞ŗO܂B");
                    getData().addLine("// Őʏ{܂B");
                    if (bundle.getWsClientException01().length() > 0) {
                        getData().addLine(
                                replaceKeyword(bundle.getWsClientException01(),
                                        operation));
                    }
                    if (bundle.getWsClientException02().length() > 0) {
                        getData().addLine(
                                replaceKeyword(bundle.getWsClientException02(),
                                        operation));
                    }
                    getData().addLine("");
                    getData().addLine("// OIuWFNǵÂ܂܃X[܂B");
                    getData().addLine("throw ex;");
                    getData().addLine("}");

                    // WebException Lb`
                    addUsingType(new IgType("System.Net.WebException"));
                    addUsingType(new IgType("System.Xml.XmlQualifiedName"));
                    getData().addLine("catch(WebException ex)");
                    getData().addLine("{");
                    getData().addLine("// WebExceptionʂɊ荞ŗO܂B");
                    getData().addLine("// Őʏ{܂B");
                    if (bundle.getWsClientException01().length() > 0) {
                        getData().addLine(
                                replaceKeyword(bundle.getWsClientException01(),
                                        operation));
                    }
                    if (bundle.getWsClientException02().length() > 0) {
                        getData().addLine(
                                replaceKeyword(bundle.getWsClientException02(),
                                        operation));
                    }
                    getData().addLine("");
                    getData().addLine("// OIuWFNǵÂ܂܃X[܂B");
                    getData()
                            .addLine(
                                    "throw new SoapException(\"WebException߁AWebExceptionSoapExceptionɕύX܂B\",new XmlQualifiedName(\"client\"));");
                    getData().addLine("}");
                }
            });
        }
    }

    private String replaceKeyword(final String originalString,
            final BlancoWsdlWebServiceOperation operation) {
        String line = originalString.replaceAll("/operation.name/", operation
                .getName());
        line = line.replaceAll("/service.name/", targetServiceName);
        line = line.replaceAll("/operation.name/", operation.getName());
        line = line.replaceAll("/operation.input.name/", operation.getInput()
                .getName());
        line = line.replaceAll("/operation.output.name/", operation.getOutput()
                .getName());
        return line;
    }
}
