/*
 * blancoCodeGenerator
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgType;
import blanco.commons.util.BlancoStringUtil;

/**
 * blancoCodeGeneratorł̌^킷NXB
 * 
 * @author Yasuo Nakanishi (1st version)
 * @author IGA Tosiki (2nd version)
 */
public class Type {
    private final BlancoCgObjectFactory fCgFactory = BlancoCgObjectFactory
            .getInstance();

    /**
     * ^~܂BpbP[W܂ޒli[܂B
     */
    private String fTypeName = null;

    /**
     * WFlNXB
     */
    private String fGenerics = null;

    /**
     * pbP[Wt̃NXŌ^CX^X쐬܂B
     * 
     * @param argName
     *            pbP[Wť^w肵܂B
     */
    public Type(final String argName) {
        fTypeName = argName;
    }

    /**
     * pbP[WƃNXƂʁXɎw肵Č^CX^X쐬܂B
     * 
     * @param argPackage
     *            pbP[WB
     * @param argName
     *            pbP[W܂܂ȂNXB
     */
    public Type(final String argPackage, final String argName) {
        // pbP[W̌^ւƉH܂B
        fTypeName = argPackage + "." + argName;
    }

    /**
     * NX^Č^CX^X쐬܂B
     * 
     * @deprecated ̃RXgN^̗p͐܂B݊̂߂ɎcĂ邾łB
     * @param argType
     *            ^̏Ƃė^JavãNXB
     */
    public Type(final Class argType) {
        if (argType.isArray()) {
            // z̏ꍇɂ́AUR|[lg^Cv擾Ă疼̂擾Kv܂B
            fTypeName = argType.getComponentType().getName() + "[]";
        } else {
            // zł͂Ȃꍇɂ́APɖ̂擾܂B
            fTypeName = argType.getName();
        }
    }

    /**
     * pbP[W^擾܂B
     * 
     * IȒlƈقȂApbP[WNX߂_ɒӂĂB<br>
     * Ȃ݂blancoCggetName pbP[W܂ތ^߂܂B
     * 
     * @return pbP[W^B
     */
    public String getName() {
        final int indexLastDot = fTypeName.lastIndexOf(".");
        if (indexLastDot >= 0) {
            return fTypeName.substring(indexLastDot + 1, fTypeName.length());
        } else {
            return fTypeName;
        }
    }

    /**
     * t^pbP[W擾܂B
     * 
     * @return pbP[WB
     */
    public static String getPackage(final String argType) {
        final int indexLastDot = argType.lastIndexOf(".");
        if (indexLastDot >= 0) {
            return argType.substring(0, indexLastDot);
        } else {
            return "";
        }
    }

    /**
     * pbP[Wť^擾܂B
     * 
     * @return pbP[Wť^B
     */
    public String getFullName() {
        return fTypeName;
    }

    /**
     * WFlNXݒ肵܂B
     * 
     * o[WłÂ肪ԈĂ܂BGenerics ÂłB
     * 
     * @param argGenerics
     *            WFlNX̕ݒ肵܂B
     */
    public final void setGenerics(final String argGenerics) {
        fGenerics = argGenerics;
    }

    /**
     * WFlNX擾܂B
     * 
     * @return WFlNX̕񂪖߂܂B
     */
    public final String getGenerics() {
        return fGenerics;
    }

    /**
     * @deprecated
     * @return
     */
    public boolean isPrimitive() {
        return getName().equals(getFullName());
    }

    /**
     * @deprecated
     * @return
     */
    public boolean isArray() {
        return fTypeName.endsWith("[]");
    }

    /**
     * TypeIuWFNgBlancoCgTypeւƕϊ܂B
     * 
     * @return ϊ̃IuWFNgB
     */
    public BlancoCgType toCgType() {
        final BlancoCgType cgType = fCgFactory.createType(fTypeName);
        if (isArray()) {
            cgType.setArray(true);
        }
        if (BlancoStringUtil.null2Blank(getGenerics()).length() > 0) {
            cgType.setGenerics(getGenerics());
        }

        return cgType;
    }
}
