/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.cs;

import java.util.ArrayList;

import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgParameter;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgLangDoc(hLg)\[XR[hɓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB<br>
 * NXA\bhAtB[hȂǁAe팾hLgWJ鋤ʏłB
 * 
 * @author IGA Tosiki
 */
class BlancoCgLangDocCsSourceExpander {
    /**
     * hLgɃ\[XR[hWJ܂B
     * 
     * @param langDoc
     *            hLgB
     * @param argSourceLines
     *            \[XR[hB
     */
    public void transformLangDoc(final BlancoCgLangDoc langDoc,
            final ArrayList argSourceLines) {
        // JnEI{̂WJ܂B
        transformLangDocBody(langDoc, argSourceLines, false);
    }

    /**
     * hLĝA{̕WJ܂B
     * 
     * ̃\bh̓\[Xt@C̃t@Cwb_[WJpĂ܂B
     * 
     * @param langDoc
     * @param argSourceLines
     * @param isFileHeader
     *            t@Cwb_ǂB
     */
    public void transformLangDocBody(final BlancoCgLangDoc langDoc,
            final ArrayList argSourceLines, final boolean isFileHeader) {
        boolean isLangDocTitleStarted = false;

        String commentString = "/// ";
        if (isFileHeader) {
            commentString = "// ";
        }

        if (BlancoStringUtil.null2Blank(langDoc.getTitle()).length() > 0) {
            isLangDocTitleStarted = true;
            argSourceLines.add(commentString
                    + "<summary>"
                    + BlancoJavaSourceUtil.escapeStringAsJavaDoc(langDoc
                            .getTitle()) + "</summary>");
        }

        // s}ς݂ǂ`FbN邽߂̃tOB
        boolean isLangDocDescriptionStarted = false;

        for (int indexDescription = 0; indexDescription < langDoc
                .getDescriptionList().size(); indexDescription++) {
            final Object objDescriptionlangDoc = langDoc.getDescriptionList()
                    .get(indexDescription);
            if (objDescriptionlangDoc instanceof String == false) {
                throw new IllegalArgumentException(
                        "BlancoCgLangDocDescriptionListjava.lang.StringȊǑ^["
                                + objDescriptionlangDoc.getClass().getName()
                                + "]ɂIuWFNgZbgĂ܂B"
                                + objDescriptionlangDoc);
            }
            final String strDescrption = (String) objDescriptionlangDoc;

            if (isLangDocDescriptionStarted == false) {
                if (isLangDocTitleStarted == false) {
                    isLangDocTitleStarted = true;
                    argSourceLines.add(commentString
                            + "<summary>"
                            + BlancoJavaSourceUtil
                                    .escapeStringAsJavaDoc(strDescrption)
                            + "</summary>");
                } else {
                    isLangDocDescriptionStarted = true;
                    argSourceLines.add(commentString + "<remarks>");
                    argSourceLines.add(commentString + "<newpara>"
                            + strDescrption + "</newpara>");
                }
            } else {
                argSourceLines.add(commentString + "<newpara>" + strDescrption
                        + "</newpara>");
            }
        }

        if (isLangDocDescriptionStarted) {
            argSourceLines.add(commentString + "</remarks>");
        }

        // TODO authorWJB

        // TODO authorȊO̓WJ邱ƁB

        // \bhp[^WJB
        for (int indexParameter = 0; indexParameter < langDoc
                .getParameterList().size(); indexParameter++) {
            final Object objParameter = langDoc.getParameterList().get(
                    indexParameter);

            // ^͊ɋlߑւɃ`FbNς݂ƑO񂵂܂B
            final BlancoCgParameter cgParameter = (BlancoCgParameter) objParameter;
            final StringBuffer bufParameter = new StringBuffer();
            bufParameter.append(commentString + "<param name=\""
                    + cgParameter.getName() + "\">");
            if (BlancoStringUtil.null2Blank(cgParameter.getDescription())
                    .length() > 0) {
                bufParameter.append(BlancoJavaSourceUtil
                        .escapeStringAsJavaDoc(cgParameter.getDescription()));
            }
            bufParameter.append("</param>");
            argSourceLines.add(bufParameter.toString());
        }

        if (langDoc.getReturn() != null
                && langDoc.getReturn().getType().getName().equals("void") == false) {

            final StringBuffer bufReturn = new StringBuffer();
            bufReturn.append(commentString + "<returns>");
            if (BlancoStringUtil.null2Blank(
                    langDoc.getReturn().getDescription()).length() > 0) {
                bufReturn.append(BlancoJavaSourceUtil
                        .escapeStringAsJavaDoc(langDoc.getReturn()
                                .getDescription()));
            }
            bufReturn.append("</returns>");
            argSourceLines.add(bufReturn.toString());
        }

        // throwsXgWJ C#.NETɂ݂͑܂B
        // TODO throwXgWJɂāAhLg̐ւƓWJ邱ƁB
    }
}
