/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.js;

import java.util.ArrayList;

import blanco.cg.valueobject.BlancoCgException;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgLangDocTag;
import blanco.cg.valueobject.BlancoCgParameter;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgLangDoc(hLg)\[XR[hɓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB<br>
 * NXA\bhAtB[hȂǁAe팾hLgWJ鋤ʏłB
 * 
 * @author IGA Tosiki
 */
class BlancoCgLangDocJsSourceExpander {
    /**
     * hLgɃ\[XR[hWJ܂B
     * 
     * @param langDoc
     *            hLgB
     * @param argSourceLines
     *            \[XR[hB
     */
    public void transformLangDoc(final BlancoCgLangDoc langDoc,
            final ArrayList argSourceLines) {
        // ݂ JSDoc̃^Oo͂Ă܂B
        argSourceLines.add("/**");

        // JnEI{̂WJ܂B
        transformLangDocBody(langDoc, argSourceLines);

        argSourceLines.add("*/");
    }

    /**
     * hLĝA{̕WJ܂B
     * 
     * ̃\bh̓\[Xt@C̃t@Cwb_[WJpĂ܂B
     * 
     * @param langDoc
     * @param argSourceLines
     */
    public void transformLangDocBody(final BlancoCgLangDoc langDoc,
            final ArrayList argSourceLines) {

        if (BlancoStringUtil.null2Blank(langDoc.getTitle()).length() > 0) {
            argSourceLines.add("* "
                    + BlancoJavaSourceUtil.escapeStringAsJavaDoc(langDoc
                            .getTitle()));
        }

        // authorȂǕtWJB
        if (langDoc.getTagList() != null) {
            for (int index = 0; index < langDoc.getTagList().size(); index++) {
                final BlancoCgLangDocTag langDocTag = (BlancoCgLangDocTag) langDoc
                        .getTagList().get(index);

                if (langDocTag.getName() == null) {
                    throw new IllegalArgumentException(
                            "BlancoCgLangDocTagnamenull^܂B"
                                    + langDocTag.toString());
                }
                if (langDocTag.getValue() == null) {
                    throw new IllegalArgumentException(
                            "BlancoCgLangDocTagvaluenull^܂B"
                                    + langDocTag.toString());
                }

                final StringBuffer buf = new StringBuffer();
                buf.append("* @" + langDocTag.getName() + " ");
                if (BlancoStringUtil.null2Blank(langDocTag.getKey()).length() > 0) {
                    buf.append(langDocTag.getKey() + " ");
                }
                buf.append(BlancoJavaSourceUtil
                        .escapeStringAsJavaDoc(langDocTag.getValue()));
                argSourceLines.add(buf.toString());
            }
        }

        // \bhp[^WJB
        for (int indexParameter = 0; indexParameter < langDoc
                .getParameterList().size(); indexParameter++) {
            final Object objParameter = langDoc.getParameterList().get(
                    indexParameter);

            // ^͊ɋlߑւɃ`FbNς݂ƑO񂵂܂B
            final BlancoCgParameter cgParameter = (BlancoCgParameter) objParameter;
            final StringBuffer bufParameter = new StringBuffer();
            bufParameter.append("* @param {" + cgParameter.getType().getName()
                    + "} " + cgParameter.getName());
            if (BlancoStringUtil.null2Blank(cgParameter.getDescription())
                    .length() > 0) {
                bufParameter.append(" "
                        + BlancoJavaSourceUtil
                                .escapeStringAsJavaDoc(cgParameter
                                        .getDescription()));
            }
            argSourceLines.add(bufParameter.toString());
        }

        if (langDoc.getReturn() != null
                && langDoc.getReturn().getType().getName().equals("void") == false) {

            final StringBuffer bufReturn = new StringBuffer();
            bufReturn.append("* @return");
            if (BlancoStringUtil.null2Blank(
                    langDoc.getReturn().getDescription()).length() > 0) {
                bufReturn.append(" "
                        + BlancoJavaSourceUtil.escapeStringAsJavaDoc(langDoc
                                .getReturn().getDescription()));
            }
            argSourceLines.add(bufReturn.toString());

            // JSDocł @type ɂ^\悤ɂȂĂ܂B
            argSourceLines.add("* @type "
                    + langDoc.getReturn().getType().getName());
        }

        // throwsXgWJB
        for (int indexThrow = 0; indexThrow < langDoc.getThrowList().size(); indexThrow++) {
            final Object objThrow = langDoc.getThrowList().get(indexThrow);

            // ^͊ɋlߑւɃ`FbNς݂ƑO񂵂܂B
            final BlancoCgException cgException = (BlancoCgException) objThrow;
            final StringBuffer bufThrow = new StringBuffer();

            // hLgɂẮAblancoCgTypeɊւ鋤ʏ𗘗p邱Ƃ͂ł܂B
            // ʂɋLqs܂B
            bufThrow.append("* @throws "
                    + BlancoNameUtil.trimJavaPackage(cgException.getType()
                            .getName()));
            if (BlancoStringUtil.null2Blank(cgException.getDescription())
                    .length() > 0) {
                bufThrow.append(" "
                        + BlancoJavaSourceUtil
                                .escapeStringAsJavaDoc(cgException
                                        .getDescription()));
            }
            argSourceLines.add(bufThrow.toString());
        }

        for (int indexDescription = 0; indexDescription < langDoc
                .getDescriptionList().size(); indexDescription++) {
            final Object objDescriptionlangDoc = langDoc.getDescriptionList()
                    .get(indexDescription);
            if (objDescriptionlangDoc instanceof String == false) {
                throw new IllegalArgumentException(
                        "BlancoCgLangDocDescriptionListjava.lang.StringȊǑ^["
                                + objDescriptionlangDoc.getClass().getName()
                                + "]ɂIuWFNgZbgĂ܂B"
                                + objDescriptionlangDoc);
            }
            final String strDescrption = (String) objDescriptionlangDoc;

            argSourceLines.add("* " + strDescrption);
        }
    }
}
