/*
 * blancoCodeGenerator
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.implementor;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

import blanco.cg.BlancoCgObjectFactory;
import blanco.ig.expander.method.MethodExpander;

/**
 * blancoCodeGenerator̎R[hǉ邽߂̃NXB
 * 
 * @author Yasuo Nakanishi (1st version)
 * @author IGA Tosiki (2nd version)
 */
public class ImplementData {
    /**
     * blanco Framework̃IuWFNgt@NgB
     */
    private final BlancoCgObjectFactory fCgFactory = BlancoCgObjectFactory
            .getInstance();

    /**
     * o͐惁\bhL܂B
     */
    private MethodExpander fMethod = null;

    /**
     * R[hǉ邽߂̃NX̃CX^X𐶐܂B
     * 
     * @param argMethod
     *            o͐̃\bhIuWFNgB
     */
    public ImplementData(final MethodExpander argMethod) {
        fMethod = argMethod;
        _implementList = new ArrayList();
    }

    /**
     * @deprecated
     */
    private List _implementList = null;

    /**
     * @deprecated
     */
    private Stack _blockStack = new Stack();

    /**
     * @deprecated
     */
    public boolean isEmpty() {
        return _implementList.size() == 0;
    }

    /**
     * @deprecated
     */
    public void pushBlock(Block block) {
        _blockStack.push(block);
    }

    /**
     * @deprecated
     */
    public Block getCurrentBlock() {
        return (Block) _blockStack.peek();
    }

    /**
     * @deprecated
     */
    public String indent(String line) {
        StringBuffer sb = new StringBuffer(line);
        return new String(sb);
    }

    /**
     * R[ho͐惁\bhւƒǉ܂B
     * 
     * @param argLine
     *            R[h̍sB
     */
    public void addLine(final String argLine) {
        fMethod.getCgMethod().getLineList().add(fCgFactory.createLine(argLine));
    }

    /**
     * @deprecated
     */
    private boolean isBlockEnd(String line) {
        boolean result = false;
        if (line.startsWith("}")) {
            result = true;
        }
        return result;
    }

    /**
     * @deprecated
     */
    private boolean isBlockStart(String line) {
        boolean result = false;
        if (line.endsWith("{")) {
            result = true;
        }
        return result;
    }

    /**
     * @deprecated
     */
    public void popBlock() {
        _blockStack.pop();
    }

    /**
     * @deprecated
     */
    public List getImplementList() {
        return _implementList;
    }

    /**
     * @deprecated
     */
    public List getUsingTypeList() {
        return fMethod.getImportList();
    }
}
