/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.js;

import java.util.ArrayList;

import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * BlancoCgSourceFilêȂ importWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB<br>
 * importWJ͈ӊOɂGȏłB
 * 
 * @author IGA Tosiki
 */
class BlancoCgImportJsSourceExpander {
    /**
     * importWJ邽߂̃AJ[B
     */
    private static final String REPLACE_IMPORT_HERE = "/*replace import here*/";

    /**
     * ꂽAJ[̃CfbNXB
     * 
     * ̃NX̏̉ߒ importҏW܂A̓sx ̒lXV܂B
     */
    private int fFindReplaceImport = -1;

    /**
     * importWJ܂B
     * 
     * ̃\bh̓NXWJE\bhWJȂǈꎮIɌĂяo悤ɂ܂B
     * 
     * @param argSourceFile
     *            \[Xt@CCX^XB
     * @param argSourceLines
     *            \[XsC[WB(java.lang.Stringi[܂)
     */
    public void transformImport(final BlancoCgSourceFile argSourceFile,
            final ArrayList argSourceLines) {
        // AJ[܂B
        fFindReplaceImport = findAnchorString(argSourceLines);
        if (fFindReplaceImport < 0) {
            throw new IllegalArgumentException("import̒u𔭌邱Ƃł܂łB");
        }

        // AJ[܂B
        removeAnchorString(argSourceLines);
    }

    /**
     * uAJ[̍s(0IW)܂B
     * 
     * @return AJ[̈ʒu(0IW)BłȂꍇɂ-1B
     * @param argSourceLines
     *            \[XXgB
     */
    private static final int findAnchorString(final ArrayList argSourceLines) {
        for (int index = 0; index < argSourceLines.size(); index++) {
            final String line = (String) argSourceLines.get(index);
            if (line.equals(REPLACE_IMPORT_HERE)) {
                // ܂B
                return index;
            }
        }

        // ł܂łBłȂƂ -1 ߂܂B
        return -1;
    }

    /**
     * AJ[}܂B
     * 
     * ̌㔼ŃC|[gҐȂ܂A̍ۂɎQƂAJ[ǉĂ܂B<br>
     * ̃\bh͑̃NXĂяo܂B
     * 
     * @param argSourceLines
     *            \[XXgB
     */
    public static final void insertAnchorString(final ArrayList argSourceLines) {
        argSourceLines.add(BlancoCgImportJsSourceExpander.REPLACE_IMPORT_HERE);
    }

    /**
     * AJ[܂B
     * 
     * @param argSourceLines
     *            \[XXgB
     */
    private static final void removeAnchorString(final ArrayList argSourceLines) {
        // ŌɃAJ[񂻂̂̂B
        int findReplaceImport2 = findAnchorString(argSourceLines);
        if (findReplaceImport2 < 0) {
            throw new IllegalArgumentException("import̒u𔭌邱Ƃł܂łB");
        }
        argSourceLines.remove(findReplaceImport2);
    }
}
