/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.MethodExpander;

public class BlancoEclipsePluginGenExpandDocumentProvider {
    public static final void expand(final Element elementCommon,
            final NodeList listList, final File directoryTarget) {
        final String pluginName = BlancoXmlUtil.getTextContent(elementCommon,
                "name");
        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");

        final ClassExpander classExpander = new ClassExpander(new Type(
                packageName + ".editors", BlancoNameAdjuster
                        .toClassName(pluginName)
                        + "DocumentProvider")) {

            protected void expandClassStruct() {
                addFileComment("EclipsevOC [" + pluginName
                        + "]̃hLgvoC_NX");
                getJavaDoc().addLine(
                        "EclipsevOC [" + pluginName + "]̃hLgvoC_NXB");
                getJavaDoc().addLine("");
                if (description != null) {
                    getJavaDoc().addLine(
                            BlancoJavaSourceUtil
                                    .escapeStringAsJavaDoc(description)
                                    + "<br>");
                }

                setSuperClass(new Type(
                        "org.eclipse.ui.editors.text.StorageDocumentProvider"));

                addImport(new Type("java.io.ByteArrayInputStream"));
                addImport(new Type("java.io.InputStream"));
                addImport(new Type("java.io.UnsupportedEncodingException"));
                addImport(new Type("org.eclipse.core.runtime.CoreException"));
                addImport(new Type("org.eclipse.core.runtime.IProgressMonitor"));
                addImport(new Type("org.eclipse.jface.text.IDocument"));
                addImport(new Type("org.eclipse.ui.IFileEditorInput"));
                addImport(new Type(
                        "org.eclipse.ui.editors.text.StorageDocumentProvider"));

                addMethod(new MethodExpander("setDocumentContent") {
                    protected Scope getScope() {
                        return Scope.PROTECTED;
                    }

                    public void setupSignature() {
                        addArgument(new Value(new Type(
                                "org.eclipse.jface.text.IDocument"), "document"));
                        addArgument(new Value(new Type("java.io.InputStream"),
                                "contentStream"));
                        addArgument(new Value(new Type("java.lang.String"),
                                "encodingIgnored"));
                        addException(new Type(
                                "org.eclipse.core.runtime.CoreException"));
                        getJavaDoc().addLine("hLg̓ǂݍݏI[o[Ch܂B");
                        getJavaDoc().addParameter("document", "hLgIuWFNg");
                        getJavaDoc().addParameter("contentStream",
                                "Rec̃Xg[");
                        getJavaDoc().addParameter("encodingIgnored",
                                "GR[fBOw肪Ăяon܂B̃p[^͖܂B");
                    }

                    public void implement() {
                        getData().addLine("// GR[fBO͖ċI UTF-8Ƃ܂B");
                        getData()
                                .addLine(
                                        "super.setDocumentContent(document, contentStream, \"UTF-8\");");
                    }

                });

                addMethod(new MethodExpander("doSaveDocument") {
                    protected Scope getScope() {
                        return Scope.PROTECTED;
                    }

                    public void setupSignature() {
                        addArgument(new Value(new Type(
                                "org.eclipse.core.runtime.IProgressMonitor"),
                                "monitor"));
                        addArgument(new Value(new Type("java.lang.Object"),
                                "element"));
                        addArgument(new Value(new Type(
                                "org.eclipse.jface.text.IDocument"), "document"));
                        addArgument(new Value(new Type("boolean"), "overwrite"));
                        addException(new Type(
                                "org.eclipse.core.runtime.CoreException"));
                        getJavaDoc().addLine("hLg̕ۑI[o[Ch܂B");
                        getJavaDoc().addParameter("monitor", "Eclipse̐ij^");
                        getJavaDoc().addParameter("element", "Gg");
                        getJavaDoc().addParameter("document", "hLgIuWFNg");
                        getJavaDoc().addParameter("overwrite", "㏑ǂ");
                    }

                    public void implement() {
                        getData().addLine(
                                "if (element instanceof IFileEditorInput) {");
                        getData().addLine("// ̏ꏊŕۑs܂B");
                        getData()
                                .addLine(
                                        "IFileEditorInput input = (IFileEditorInput) element;");
                        getData()
                                .addLine(
                                        "String editorText = getDocument(input).get();");
                        getData().addLine("");
                        getData().addLine("try {");
                        getData()
                                .addLine(
                                        "input.getFile().setContents(new ByteArrayInputStream(editorText.getBytes(\"UTF-8\")), true, false, monitor);");
                        getData().addLine(
                                "} catch (UnsupportedEncodingException e) {");
                        getData().addLine("// ̃P[X݂͑܂B");
                        getData().addLine("e.printStackTrace();");
                        getData().addLine("}");
                        getData().addLine("}");
                    }
                });
            }
        };
        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
