/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.method.Constructor;
import blanco.ig.expander.method.MethodExpander;

public class BlancoEclipsePluginGenExpandPlugin {
    public static final void expand(final Element elementCommon,
            final NodeList listList, final File directoryTarget) {
        final String pluginName = BlancoXmlUtil.getTextContent(elementCommon,
                "name");
        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");

        // g킷^B
        final Type typeMyself = new Type(packageName, BlancoNameAdjuster
                .toClassName(pluginName)
                + "Plugin");
        final ClassExpander classExpander = new ClassExpander(typeMyself) {

            protected void expandClassStruct() {
                addFileComment("EclipsevOC [" + pluginName + "]̃vOCNX");
                getJavaDoc().addLine(
                        "EclipsevOC [" + pluginName + "]̃vOCNXB");
                getJavaDoc().addLine("");
                if (description != null) {
                    getJavaDoc().addLine(
                            BlancoJavaSourceUtil
                                    .escapeStringAsJavaDoc(description)
                                    + "<br>");
                }

                setSuperClass(new Type("org.eclipse.ui.plugin.AbstractUIPlugin"));

                addImport(new Type("org.eclipse.core.runtime.IStatus"));
                addImport(new Type("org.eclipse.core.runtime.Platform"));
                addImport(new Type("org.eclipse.core.runtime.Status"));
                addImport(new Type("org.eclipse.jface.resource.ImageDescriptor"));
                addImport(new Type("org.eclipse.ui.plugin.AbstractUIPlugin"));
                addImport(new Type("org.osgi.framework.BundleContext"));

                final Element elementListRoot = (Element) listList.item(0);
                final NodeList listChildNodes = elementListRoot.getChildNodes();
                for (int index = 0; index < listChildNodes.getLength(); index++) {
                    final Element elementList = (Element) listChildNodes
                            .item(index);
                    final String no = BlancoXmlUtil.getTextContent(elementList,
                            "no");
                    final String action = BlancoXmlUtil.getTextContent(
                            elementList, "action");
                    final String attributeDescription = BlancoXmlUtil
                            .getTextContent(elementList, "description");

                    if (action == null || action.trim().length() == 0) {
                        // actionw肳ĂȂꍇɂ͏܂B
                        continue;
                    }

                    // TODO قƂ́AŃANVꗗJavaDocɒǋL܂B
                }

                final FieldExpander field1 = new FieldExpander(typeMyself,
                        "plugin") {
                    protected boolean isStatic() {
                        return true;
                    }
                };
                field1.getJavaDoc().addLine("̃vOCg̋LCX^XB");
                addField(field1);

                addMethod(new Constructor(BlancoNameAdjuster
                        .toClassName(pluginName)
                        + "Plugin") {
                    public void setupSignature() {
                    }

                    public void implement() {
                        getData().addLine("plugin = this;");
                    }
                });

                addMethod(new MethodExpander("start") {
                    public void setupSignature() {
                        addArgument(new Value(new Type(
                                "org.osgi.framework.BundleContext"), "context"));
                        addException(new Type("java.lang.Exception"));
                        getJavaDoc()
                                .addLine(
                                        "This method is called upon plug-in activation");
                        getJavaDoc()
                                .addParameter("context", "vOCoh̃ReLXg");
                    }

                    public void implement() {
                        getData().addLine("super.start(context);");
                    }
                });

                addMethod(new MethodExpander("stop") {
                    public void setupSignature() {
                        addArgument(new Value(new Type(
                                "org.osgi.framework.BundleContext"), "context"));
                        addException(new Type("java.lang.Exception"));
                        getJavaDoc()
                                .addLine(
                                        "This method is called when the plug-in is stopped");
                        getJavaDoc()
                                .addParameter("context", "vOCoh̃ReLXg");
                    }

                    public void implement() {
                        getData().addLine("super.stop(context);");
                        getData().addLine("plugin = null;");
                    }
                });

                addMethod(new MethodExpander("getDefault") {
                    protected boolean isStatic() {
                        return true;
                    }

                    public void setupSignature() {
                        setReturnType(typeMyself);
                        getJavaDoc().addLine("Returns the shared instance.");
                        getJavaDoc().addReturn("vOC̋LCX^XB");
                    }

                    public void implement() {
                        getData().addLine("return plugin;");
                    }
                });

                addMethod(new MethodExpander("getImageDescriptor") {
                    protected boolean isStatic() {
                        return true;
                    }

                    public void setupSignature() {
                        addArgument(new Value(new Type("java.lang.String"),
                                "path"));
                        setReturnType(new Type(
                                "org.eclipse.jface.resource.ImageDescriptor"));
                        getJavaDoc()
                                .addLine(
                                        "Returns an image descriptor for the image file at the given plug-in relative path.");
                        getJavaDoc().addParameter("path", "C[Wւ̃pX");
                        getJavaDoc().addReturn("擾ꂽC[WfXNv^");
                    }

                    public void implement() {
                        getData().addLine(
                                "return AbstractUIPlugin.imageDescriptorFromPlugin(\""
                                        + packageName + "\", path);");
                    }
                });

                addMethod(new MethodExpander("log") {
                    protected boolean isStatic() {
                        return true;
                    }

                    public void setupSignature() {
                        addArgument(new Value(new Type("java.lang.Throwable"),
                                "ex"));
                        getJavaDoc().addLine("Eclipseɑ΂ăMOs܂B");
                        getJavaDoc().addParameter("ex", "MO̍ۂɗpOIuWFNg");
                    }

                    public void implement() {
                        getData()
                                .addLine(
                                        BlancoNameAdjuster
                                                .toClassName(pluginName)
                                                + "Plugin"
                                                + ".getDefault().getLog().log(new Status(IStatus.WARNING, \""
                                                + packageName
                                                + "\", -1, ex.toString(), ex));");
                    }
                });

                addMethod(new MethodExpander("getPluginRoot") {
                    protected boolean isStatic() {
                        return true;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine("vOC̃[gfBNg擾܂B");
                        getJavaDoc().addReturn(
                                "[gfBNgURL getPath()ƃtpXɂȂ܂B");
                        setReturnType(new IgType("java.net.URL"));
                        addException(new IgType("java.io.IOException"));
                    }

                    public void implement() {
                        getData()
                                .addLine(
                                        "final URL relativeURL = getDefault().getBundle().getEntry(\"/\");");
                        getData()
                                .addLine(
                                        "final URL localURL = Platform.asLocalURL(relativeURL);");
                        getData().addLine("return localURL;");
                    }
                });
            }
        };

        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
