/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.MethodExpander;

public class BlancoEclipsePluginGenExpandPluginUtil {
    public static final void expand(final Element elementCommon,
            final NodeList listList, final File directoryTarget) {
        final String pluginName = BlancoXmlUtil.getTextContent(elementCommon,
                "name");
        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");

        final ClassExpander classExpander = new ClassExpander(new Type(
                packageName + ".editors", BlancoNameAdjuster
                        .toClassName(pluginName)
                        + "PluginUtil")) {

            protected void expandClassStruct() {
                addFileComment("EclipsevOC [" + pluginName + "]̃[eBeBNX");
                getJavaDoc().addLine(
                        "EclipsevOC [" + pluginName + "]̃[eBeBNXB");
                getJavaDoc().addLine("");
                if (description != null) {
                    getJavaDoc().addLine(
                            BlancoJavaSourceUtil
                                    .escapeStringAsJavaDoc(description)
                                    + "<br>");
                }

                addImport(new Type("org.eclipse.core.resources.IFile"));
                addImport(new Type("org.eclipse.core.resources.IFolder"));
                addImport(new Type("org.eclipse.core.resources.IResource"));
                addImport(new Type("org.eclipse.core.runtime.CoreException"));
                addImport(new Type("org.eclipse.core.runtime.IProgressMonitor"));

                addMethod(new MethodExpander("refreshFolder") {
                    protected boolean isStatic() {
                        return true;
                    }

                    public void setupSignature() {
                        addArgument(new Value(new Type(
                                "org.eclipse.core.resources.IFile"), "input"));
                        addArgument(new Value(new Type(
                                "org.eclipse.core.runtime.IProgressMonitor"),
                                "monitor"));
                        addArgument(new Value(new Type("java.lang.String"),
                                "folderName"));
                        setReturnType(new Type("boolean"));
                        addException(new Type(
                                "org.eclipse.core.runtime.CoreException"));
                        getJavaDoc().addLine("vWFNg wtH_XV܂B");
                        getJavaDoc().addParameter("input", "GfB^ݏĂt@C");
                        getJavaDoc().addParameter("monitor", "Eclipse̐ij^");
                        getJavaDoc().addParameter("folderName", "Ώۂ̃tH_");
                    }

                    public void implement() {
                        getData()
                                .addLine(
                                        "IFolder folderCheck = input.getProject().getFolder(folderName);");
                        getData().addLine("if (folderCheck.exists()) {");
                        getData()
                                .addLine(
                                        "folderCheck.refreshLocal(IResource.DEPTH_INFINITE, monitor);");
                        getData().addLine("return true;");
                        getData().addLine("}");
                        getData().addLine("return false;");
                    }
                });

                addMethod(new MethodExpander("createFolder") {
                    protected boolean isStatic() {
                        return true;
                    }

                    public void setupSignature() {
                        addArgument(new Value(new Type(
                                "org.eclipse.core.resources.IFile"), "input"));
                        addArgument(new Value(new Type(
                                "org.eclipse.core.runtime.IProgressMonitor"),
                                "monitor"));
                        addArgument(new Value(new Type("java.lang.String"),
                                "argFolderName"));
                        addException(new Type(
                                "org.eclipse.core.runtime.CoreException"));
                        getJavaDoc().addLine("vWFNg wtH_쐬܂B");
                        getJavaDoc().addParameter("input", "GfB^ݏĂt@C");
                        getJavaDoc().addParameter("monitor", "Eclipse̐ij^");
                        getJavaDoc()
                                .addParameter("argFolderName", "Ώۂ̃tH_");
                    }

                    public void implement() {
                        getData().addLine("IFolder folderCurrent = null;");
                        getData().addLine("String folderName = argFolderName;");
                        getData()
                                .addLine(
                                        "for (boolean found = false; found == false;) {");
                        getData().addLine("if (folderName.indexOf('/') < 0) {");
                        getData().addLine("found = true;");
                        getData().addLine("if (folderCurrent == null) {");
                        getData()
                                .addLine(
                                        "folderCurrent = input.getProject().getFolder(folderName);");
                        getData().addLine("} else {");
                        getData()
                                .addLine(
                                        "folderCurrent = folderCurrent.getFolder(folderName);");
                        getData().addLine("}");
                        getData().addLine("} else {");
                        getData()
                                .addLine(
                                        "String nextFolder = folderName.substring(0, folderName.indexOf('/'));");
                        getData()
                                .addLine(
                                        "folderName = folderName.substring(folderName.indexOf('/') + 1);");
                        getData().addLine("if (folderCurrent == null) {");
                        getData()
                                .addLine(
                                        "folderCurrent = input.getProject().getFolder(nextFolder);");
                        getData().addLine("} else {");
                        getData()
                                .addLine(
                                        "folderCurrent = folderCurrent.getFolder(nextFolder);");
                        getData().addLine("}");
                        getData().addLine("}");
                        getData().addLine(
                                "if (folderCurrent.exists() == false) {");
                        getData().addLine(
                                "folderCurrent.create(true, true, monitor);");
                        getData().addLine("}");
                        getData().addLine("}");
                    }
                });

                addMethod(new MethodExpander("findFolder") {
                    protected boolean isStatic() {
                        return true;
                    }

                    public void setupSignature() {
                        addArgument(new Value(new Type(
                                "org.eclipse.core.resources.IFile"), "input"));
                        addArgument(new Value(new Type(
                                "org.eclipse.core.runtime.IProgressMonitor"),
                                "monitor"));
                        addArgument(new Value(new Type("java.lang.String"),
                                "argFolderName"));
                        setReturnType(new Type(
                                "org.eclipse.core.resources.IFolder"));
                        addException(new Type(
                                "org.eclipse.core.runtime.CoreException"));
                        getJavaDoc().addLine("vWFNg wtH_܂B");
                        getJavaDoc().addParameter("input", "GfB^ݏĂt@C");
                        getJavaDoc().addParameter("monitor", "Eclipse̐ij^");
                        getJavaDoc()
                                .addParameter("argFolderName", "Ώۂ̃tH_");
                    }

                    public void implement() {
                        getData().addLine("IFolder folderCurrent = null;");
                        getData().addLine("String folderName = argFolderName;");
                        getData()
                                .addLine(
                                        "for (boolean found = false; found == false;) {");
                        getData().addLine("if (folderName.indexOf('/') < 0) {");
                        getData().addLine("found = true;");
                        getData().addLine("if (folderCurrent == null) {");
                        getData()
                                .addLine(
                                        "folderCurrent = input.getProject().getFolder(folderName);");
                        getData().addLine("} else {");
                        getData()
                                .addLine(
                                        "folderCurrent = folderCurrent.getFolder(folderName);");
                        getData().addLine("}");
                        getData().addLine("} else {");
                        getData()
                                .addLine(
                                        "String nextFolder = folderName.substring(0, folderName.indexOf('/'));");
                        getData()
                                .addLine(
                                        "folderName = folderName.substring(folderName.indexOf('/') + 1);");
                        getData().addLine("if (folderCurrent == null) {");
                        getData()
                                .addLine(
                                        "folderCurrent = input.getProject().getFolder(nextFolder);");
                        getData().addLine("} else {");
                        getData()
                                .addLine(
                                        "folderCurrent = folderCurrent.getFolder(nextFolder);");
                        getData().addLine("}");
                        getData().addLine("}");
                        getData().addLine("}");
                        getData().addLine("return folderCurrent;");
                    }
                });

                addMethod(new MethodExpander("deleteFolder") {
                    protected boolean isStatic() {
                        return true;
                    }

                    public void setupSignature() {
                        addArgument(new Value(new Type(
                                "org.eclipse.core.resources.IFile"), "input"));
                        addArgument(new Value(new Type(
                                "org.eclipse.core.runtime.IProgressMonitor"),
                                "monitor"));
                        addArgument(new Value(new Type("java.lang.String"),
                                "folderName"));
                        addException(new Type(
                                "org.eclipse.core.runtime.CoreException"));
                        getJavaDoc().addLine("vWFNg wtH_폜܂B");
                        getJavaDoc().addParameter("input", "GfB^ݏĂt@C");
                        getJavaDoc().addParameter("monitor", "Eclipse̐ij^");
                        getJavaDoc().addParameter("folderName", "Ώۂ̃tH_");
                    }

                    public void implement() {
                        getData()
                                .addLine(
                                        "IFolder folder = findFolder(input, monitor, folderName);");
                        getData().addLine("if (folder != null) {");
                        getData().addLine("folder.delete(true, monitor);");
                        getData().addLine("}");
                    }
                });
            }
        };
        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
