/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.meta2xml;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.MethodExpander;
import blanco.meta2xml.valueobject.BlancoMeta2XmlProcessStructure;

/**
 * blancoValueObject̎傽NXB
 * 
 * blancoValueObject\XMLt@C Java\[XR[h܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoMeta2XmlXml2JavaClass {

    /**
     * ValueObject\XMLt@C Java\[XR[h܂B
     * 
     * @param metaXmlSourceFile
     *            ValueObjectɊւ郁^񂪊܂܂ĂXMLt@C
     * @param directoryTarget
     *            \[XR[hfBNg
     * @throws IOException
     *             o͗Oꍇ
     */
    public void process(final File metaXmlSourceFile, final File directoryTarget)
            throws IOException {

        final DOMResult result = BlancoXmlUtil
                .transformFile2Dom(metaXmlSourceFile);

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementCommon = BlancoXmlUtil.getElement(
                        listSheet.item(index), "blancometa2xml-process-common");
                if (elementCommon == null) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                final String name = BlancoXmlUtil.getTextContent(elementCommon,
                        "name");
                if (name == null || name.trim().length() == 0) {
                    continue;
                }

                expandSheet(elementCommon, directoryTarget);
            }
        }
    }

    /**
     * V[gWJ܂B
     * 
     * @param elementCommon
     *            ݏĂCommonm[h
     * @param directoryTarget
     *            o͐tH_B
     */
    private void expandSheet(final Element elementCommon,
            final File directoryTarget) {
        final BlancoMeta2XmlProcessStructure processStructure = new BlancoMeta2XmlProcessStructure();
        processStructure.setName(BlancoXmlUtil.getTextContent(elementCommon,
                "name"));
        processStructure.setPackage(BlancoXmlUtil.getTextContent(elementCommon,
                "package"));
        if (processStructure.getPackage() == null
                || processStructure.getPackage().trim().length() == 0) {
            throw new IllegalArgumentException("^t@C-XMLϊ` NX["
                    + processStructure.getName() + "]̃pbP[Ww肳Ă܂B");
        }

        if (BlancoXmlUtil.getTextContent(elementCommon, "description") != null) {
            processStructure.setDescription(BlancoXmlUtil.getTextContent(
                    elementCommon, "description"));
        }
        if (BlancoXmlUtil.getTextContent(elementCommon, "fileDescription") != null) {
            processStructure.setFileDescription(BlancoXmlUtil.getTextContent(
                    elementCommon, "fileDescription"));
        }

        processStructure.setConvertDefFile(BlancoXmlUtil.getTextContent(
                elementCommon, "convertDefFile"));
        if (processStructure.getConvertDefFile() == null
                || processStructure.getConvertDefFile().trim().length() == 0) {
            throw new IllegalArgumentException("^t@C-XMLϊ` NX["
                    + processStructure.getName() + "]̕ϊ`t@Cw肳Ă܂B");
        }

        if (BlancoXmlUtil.getTextContent(elementCommon, "inputFileExt") != null) {
            processStructure.setInputFileExt(BlancoXmlUtil.getTextContent(
                    elementCommon, "inputFileExt"));
        }
        if (BlancoXmlUtil.getTextContent(elementCommon, "outputFileExt") != null) {
            processStructure.setOutputFileExt(BlancoXmlUtil.getTextContent(
                    elementCommon, "outputFileExt"));
        }

        expandJavaSource(processStructure, directoryTarget);
    }

    /**
     * WꂽɁAJava\[XR[ho͂܂B
     * 
     * @param processStructure
     *            \
     * @param directoryTarget
     *            o͐tH_B
     */
    private void expandJavaSource(
            final BlancoMeta2XmlProcessStructure processStructure,
            final File directoryTarget) {
        final ClassExpander classExpander = new ClassExpander(new Type(
                processStructure.getPackage(), processStructure.getName())) {
            protected void expandClassStruct() {
                addImport(new Type("java.io.BufferedInputStream"));
                addImport(new Type("java.io.BufferedOutputStream"));
                addImport(new Type("java.io.FileInputStream"));
                addImport(new Type("java.io.FileOutputStream"));
                addImport(new Type("java.io.IOException"));
                addImport(new Type("java.io.InputStream"));
                addImport(new Type("java.io.OutputStream"));
                addImport(new Type("javax.xml.transform.TransformerException"));
                addImport(new Type(
                        "blanco.commons.calc.parser.BlancoCalcParser"));

                if (processStructure.getFileDescription() != null) {
                    String lines = BlancoJavaSourceUtil
                            .escapeStringAsJavaDoc(processStructure
                                    .getFileDescription());
                    addFileComment(lines);

                }

                if (processStructure.getDescription() != null) {
                    String lines = BlancoJavaSourceUtil
                            .escapeStringAsJavaDoc(processStructure
                                    .getDescription());
                    getJavaDoc().addLine(lines);
                }

                addMethod(new MethodExpander("process") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                "Excelt@C̃Xg[XMLt@C̃Xg[ɕϊ܂B<br>");
                        getJavaDoc().addLine("`t@C͓IɃpXێĂ܂B");

                        addArgument(new Value(new Type("java.io.InputStream"),
                                "inStreamMetaSource"));
                        getJavaDoc().addParameter("inStreamMetaSource",
                                "^t@C̓̓Xg[B");

                        addArgument(new Value(new Type("java.io.OutputStream"),
                                "outStreamTarget"));
                        getJavaDoc().addParameter("outStreamTarget",
                                "XMLt@C̏o̓Xg[B");

                        addException(new Type("java.io.IOException"));
                        getJavaDoc().addException(
                                new Type("java.io.IOException"),
                                "o͗OꍇB");

                        addException(new Type(
                                "javax.xml.transform.TransformerException"));
                        getJavaDoc()
                                .addException(
                                        new Type(
                                                "javax.xml.transform.TransformerException"),
                                        "XMLϊOꍇB");
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine("if (inStreamMetaSource == null) {");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\""
                                                + processStructure.getName()
                                                + ": Invalid argument: inStreamMetaSource is null.\");");
                        getData().addLine("}");
                        getData().addLine("if (outStreamTarget == null) {");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\""
                                                + processStructure.getName()
                                                + ": Invalid argument: outStreamTarget is null.\");");
                        getData().addLine("}");
                        getData().addLine("");
                        getData().addLine("InputStream inStreamDef = null;");
                        getData().addLine("try {");
                        getData().addLine(
                                "// ̃NXgƂȂNX[_XMLݒt@C̃[hȂ܂B");
                        getData()
                                .addLine(
                                        "final InputStream meta2xmlStream = getClass().getClassLoader().getResourceAsStream(\""
                                                + processStructure
                                                        .getConvertDefFile()
                                                + "\");");
                        getData().addLine("if (meta2xmlStream == null) {");
                        getData().addLine(
                                "throw new IllegalArgumentException(\""
                                        + processStructure.getName()
                                        + ": \[X["
                                        + processStructure.getConvertDefFile()
                                        + "]̎擾Ɏs܂.\");");
                        getData().addLine("}");
                        getData()
                                .addLine(
                                        "inStreamDef = new BufferedInputStream(meta2xmlStream);");
                        getData()
                                .addLine(
                                        "new BlancoCalcParser().process(inStreamDef, inStreamMetaSource, outStreamTarget);");
                        getData().addLine("} finally {");
                        getData().addLine("if (inStreamDef != null) {");
                        getData().addLine("inStreamDef.close();");
                        getData().addLine("}");
                        getData().addLine("}");
                    }
                });

                addMethod(new MethodExpander("process") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine("Excelt@CXMLt@Cɕϊ܂B<br>");

                        addArgument(new Value(new Type("java.io.File"),
                                "fileMeta"));
                        getJavaDoc().addParameter("fileMeta", "^t@C̓̓t@CB");

                        addArgument(new Value(new Type("java.io.File"),
                                "fileOutput"));
                        getJavaDoc().addParameter("fileOutput", "XMLt@C̏óB");

                        addException(new Type("java.io.IOException"));
                        getJavaDoc().addException(
                                new Type("java.io.IOException"),
                                "o͗OꍇB");

                        addException(new Type(
                                "javax.xml.transform.TransformerException"));
                        getJavaDoc()
                                .addException(
                                        new Type(
                                                "javax.xml.transform.TransformerException"),
                                        "XMLϊOꍇB");
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine("if (fileMeta == null) {");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\""
                                                + processStructure.getName()
                                                + ": Invalid argument: fileMeta is null.\");");
                        getData().addLine("}");
                        getData().addLine("if (fileOutput == null) {");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\""
                                                + processStructure.getName()
                                                + ": Invalid argument: fileOutput is null.\");");
                        getData().addLine("}");
                        getData().addLine("if (fileMeta.exists() == false) {");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\""
                                                + processStructure.getName()
                                                + ": Invalid argument: file file [\" + fileMeta.getAbsolutePath() + \"] not found.\");");
                        getData().addLine("}");
                        getData().addLine("");
                        getData().addLine("InputStream inStream = null;");
                        getData().addLine("OutputStream outStream = null;");
                        getData().addLine("try {");
                        getData()
                                .addLine(
                                        "inStream = new BufferedInputStream(new FileInputStream(fileMeta));");
                        getData()
                                .addLine(
                                        "outStream = new BufferedOutputStream(new FileOutputStream(fileOutput));");
                        getData().addLine("");
                        getData().addLine("// Xg[̏ł̂ŁAۂ̏Ȃ܂B");
                        getData().addLine("process(inStream, outStream);");
                        getData().addLine("");
                        getData().addLine("outStream.flush();");
                        getData().addLine("} finally {");
                        getData().addLine("if (inStream != null) {");
                        getData().addLine("inStream.close();");
                        getData().addLine("}");
                        getData().addLine("if (outStream != null) {");
                        getData().addLine("outStream.close();");
                        getData().addLine("}");
                        getData().addLine("}");
                    }
                });

                addMethod(new MethodExpander("processDirectory") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                "wfBNgExcelt@CXMLt@Cɕϊ܂B<br>");
                        getJavaDoc().addLine(
                                "w肳ꂽtH_̊gq["
                                        + processStructure.getInputFileExt()
                                        + "]̃t@C܂B<br>");
                        getJavaDoc().addLine(
                                "f[^ Ƃ̃t@CɊgq["
                                        + processStructure.getOutputFileExt()
                                        + "]t^t@C֕ۑ܂B");

                        addArgument(new Value(new Type("java.io.File"),
                                "fileMetadir"));
                        getJavaDoc().addParameter("fileMetadir",
                                "^t@Ci[Ă̓fBNgB");

                        addArgument(new Value(new Type("java.lang.String"),
                                "targetDirectory"));
                        getJavaDoc().addParameter("targetDirectory",
                                "o̓fBNgB");

                        addException(new Type("java.io.IOException"));
                        getJavaDoc().addException(
                                new Type("java.io.IOException"),
                                "o͗OꍇB");

                        addException(new Type(
                                "javax.xml.transform.TransformerException"));
                        getJavaDoc()
                                .addException(
                                        new Type(
                                                "javax.xml.transform.TransformerException"),
                                        "XMLϊOꍇB");
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine("if (fileMetadir == null) {");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\""
                                                + processStructure.getName()
                                                + ": Invalid argument: fileMetadir is null.\");");
                        getData().addLine("}");
                        getData().addLine("if (targetDirectory == null) {");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\""
                                                + processStructure.getName()
                                                + ": Invalid argument: targetDirectory is null.\");");
                        getData().addLine("}");
                        getData().addLine(
                                "if (fileMetadir.exists() == false) {");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\""
                                                + processStructure.getName()
                                                + ": Invalid argument: file [\" + fileMetadir.getAbsolutePath() + \"] not found.\");");
                        getData().addLine("}");
                        getData()
                                .addLine(
                                        "final File fileTargetDirectory = new File(targetDirectory);");
                        getData().addLine(
                                "if (fileTargetDirectory.exists() == false) {");
                        getData().addLine("// o͐fBNg݂Ȃ̂ŁAOɍ쐬܂B");
                        getData().addLine("fileTargetDirectory.mkdirs();");
                        getData().addLine("}");
                        getData().addLine("");
                        getData().addLine("// w肳ꂽfBNg̃t@Cꗗ擾܂B");
                        getData()
                                .addLine(
                                        "final File[] fileMeta = fileMetadir.listFiles();");
                        getData().addLine("if (fileMeta == null) {");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\"BlancoMeta2XmlProcessMeta2Xml: list directory [\" + fileMetadir.getAbsolutePath() + \"] is failed.\");");
                        getData().addLine("}");
                        getData()
                                .addLine(
                                        "for (int index = 0; index < fileMeta.length; index++) {");
                        getData()
                                .addLine(
                                        "if (fileMeta[index].getName().endsWith(\""
                                                + BlancoJavaSourceUtil
                                                        .escapeStringAsJavaSource(processStructure
                                                                .getInputFileExt())
                                                + "\") == false) {");
                        getData().addLine(
                                "// t@C̊gqׂ̂Ƃ͈قȂ邽ߏXLbv܂BB");
                        getData().addLine("continue;");
                        getData().addLine("}");
                        getData().addLine("");

                        getData()
                                .addLine(
                                        "if (progress(index + 1, fileMeta.length, fileMeta[index].getName()) == false) {");
                        getData().addLine("// i\珈f̎ŵŁAf܂B");
                        getData().addLine("break;");
                        getData().addLine("}");

                        getData().addLine("");
                        getData().addLine("try {");
                        getData()
                                .addLine(
                                        "process(fileMeta[index], new File(targetDirectory + \"/\" + fileMeta[index].getName() + \""
                                                + BlancoJavaSourceUtil
                                                        .escapeStringAsJavaSource(processStructure
                                                                .getOutputFileExt())
                                                + "\"));");
                        getData().addLine("} catch (Exception ex) {");
                        getData().addLine("ex.printStackTrace();");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\""
                                                + processStructure.getName()
                                                + ": Exception occurs during processing the file [\" + fileMeta[index].getAbsolutePath() + \"]. \" + ex.toString());");
                        getData().addLine("}");

                        getData().addLine("}");
                    }
                });

                addMethod(new MethodExpander("progress") {
                    protected Scope getScope() {
                        return Scope.PROTECTED;
                    }

                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine("̐i܂B<br>");
                        getJavaDoc().addLine("i\ꍇɂ͌pď肱݂܂B");

                        addArgument(new Value(new Type("int"),
                                "progressCurrent"));
                        getJavaDoc().addParameter("progressCurrent",
                                "ݏĂ錏̔ԍB");

                        addArgument(new Value(new Type("int"), "progressTotal"));
                        getJavaDoc().addParameter("progressTotal", "B");

                        addArgument(new Value(new Type("java.lang.String"),
                                "progressItem"));
                        getJavaDoc().addParameter("progressItem",
                                "ĂACeB");

                        setReturnType(new Type("boolean"));
                        getJavaDoc().addReturn("𑱍sĂ悢ǂBfalseȂ珈fB");
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine("// ɏs true ߂܂B");
                        getData().addLine("return true;");
                    }
                });
            }
        };

        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
