/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.Scope;
import blanco.ig.expander.method.IgConstructor;
import blanco.ig.expander.method.MethodExpander;

public class BlancoEclipsePluginGenExpandEditor {
    public static final void expand(final Element elementCommon,
            final NodeList listList, final File directoryTarget) {
        final String pluginName = BlancoXmlUtil.getTextContent(elementCommon,
                "name");
        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");

        final ClassExpander classExpander = new ClassExpander(
                new IgType(packageName + ".editors", "Abstract"
                        + BlancoNameAdjuster.toClassName(pluginName) + "Editor")) {
            protected boolean isAbstract() {
                return true;
            }

            protected void expandClassStruct() {
                addFileComment("EclipsevOC [" + pluginName + "]̒ۃGfB^NX");

                addImport(new IgType("java.io.ByteArrayInputStream"));
                addImport(new IgType("java.io.ByteArrayOutputStream"));
                addImport(new IgType("java.io.IOException"));
                addImport(new IgType("java.io.UnsupportedEncodingException"));
                addImport(new IgType("javax.xml.transform.dom.DOMResult"));
                addImport(new IgType("org.w3c.dom.Document"));
                addImport(new IgType("org.eclipse.swt.events.FocusEvent"));
                addImport(new IgType("org.eclipse.swt.events.FocusListener"));
                addImport(new IgType("blanco.commons.util.BlancoXmlUtil"));

                setSuperClass(new IgType(
                        "org.eclipse.ui.editors.text.TextEditor"));

                getJavaDoc().addLine(
                        "EclipsevOC [" + pluginName + "]̒ۃGfB^NXB");
                getJavaDoc().addLine("");
                if (description != null) {
                    getJavaDoc().addLine(
                            BlancoJavaSourceUtil
                                    .escapeStringAsJavaDoc(description)
                                    + "<br>");
                }

                addMethod(new IgConstructor("Abstract"
                        + BlancoNameAdjuster.toClassName(pluginName) + "Editor") {
                    public void setupSignature() {
                        getJavaDoc().addLine("GfB^NX̃RXgN^łB");
                    }

                    public void implement() {
                        getData().addLine(
                                "// ̃GR[fBOēo͂邽߂ɃvoC_ZbgĂ܂B");
                        getData().addLine(
                                "setDocumentProvider(new " + pluginName
                                        + "DocumentProvider());");
                    }
                });

                addMethod(new MethodExpander("setFocus") {
                    protected boolean isFinal() {
                        return true;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine("tH[JXZbgꂽꍇɌĂяo܂B");
                    }

                    public void implement() {
                    }
                });

                addMethod(new MethodExpander("isSaveAsAllowed") {
                    protected boolean isFinal() {
                        return true;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine("OtĕۑĂ邩ǂB");
                        getJavaDoc().addReturn("false߂܂B");
                        setReturnType(new IgType("boolean"));
                    }

                    public void implement() {
                        getData().addLine("return false;");
                    }
                });

                addMethod(new MethodExpander("isSaveOnCloseNeeded") {
                    protected boolean isFinal() {
                        return true;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine("GfB^ۂɕۑKvǂ߂܂B");
                        getJavaDoc().addReturn("true߂܂B");
                        setReturnType(new IgType("boolean"));
                    }

                    public void implement() {
                        getData().addLine("return true;");
                    }
                });

                addMethod(new MethodExpander("setFocusLostHandler") {
                    protected boolean isFinal() {
                        return true;
                    }

                    protected Scope getScope() {
                        return Scope.PROTECTED;
                    }

                    public void setupSignature() {
                        addArgument(new IgValue(new IgType(
                                "org.eclipse.swt.widgets.Control"), "target"));
                    }

                    public void implement() {
                        getData()
                                .addLine(
                                        "target.addFocusListener(new FocusListener() {");
                        getData().addLine(
                                "public void focusGained(FocusEvent e) {");
                        getData().addLine("}");
                        getData().addLine("");
                        getData().addLine(
                                "public void focusLost(FocusEvent e) {");
                        getData().addLine("saveToTextEditor();");
                        getData().addLine("}");
                        getData().addLine("}");
                        getData().addLine(");");
                    }
                });

                addMethod(new MethodExpander("loadFromTextEditor") {
                    protected boolean isFinal() {
                        return true;
                    }

                    protected Scope getScope() {
                        return Scope.PROTECTED;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine("eLXgGfB^f[^[hۂɌĂяo܂B");
                        getJavaDoc().addLine("");
                        getJavaDoc().addLine("̃\bh blancoœƎɋK肷̂łB");
                    }

                    public void implement() {
                        getData()
                                .addLine(
                                        "final String editorText = getDocumentProvider().getDocument(getEditorInput()).get();");
                        getData().addLine("");
                        getData().addLine("final DOMResult result;");
                        getData().addLine("try {");
                        getData()
                                .addLine(
                                        "result = BlancoXmlUtil.transformStream2Dom(new ByteArrayInputStream(editorText.getBytes(\"UTF-8\")));");
                        getData().addLine(
                                "} catch (UnsupportedEncodingException e) {");
                        getData().addLine("e.printStackTrace();");
                        getData().addLine("return;");
                        getData().addLine("}");
                        getData().addLine("");
                        getData()
                                .addLine("loadFromTextEditorInternal(result);");
                    }
                });

                addMethod(new MethodExpander("loadFromTextEditorInternal") {
                    protected Scope getScope() {
                        return Scope.PROTECTED;
                    }

                    protected boolean isAbstract() {
                        return true;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine("ۂɃf[^[h鏈eLq܂B");
                        addArgument(new IgValue(new IgType(
                                "javax.xml.transform.dom.DOMResult"),
                                "argResult"));
                    }

                    public void implement() {
                    }
                });

                addMethod(new MethodExpander("saveToTextEditor") {
                    protected boolean isFinal() {
                        return true;
                    }

                    protected Scope getScope() {
                        return Scope.PROTECTED;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine("eLXgGfB^f[^Z[uۂɌĂяo܂B");
                        getJavaDoc().addLine("");
                        getJavaDoc().addLine("̃\bh blancoœƎɋK肷̂łB");
                    }

                    public void implement() {
                        getData()
                                .addLine(
                                        "Document document = saveToTextEditorInternal();");
                        getData().addLine("if (document == null) {");
                        getData().addLine("return;");
                        getData().addLine("}");
                        getData().addLine("");
                        getData()
                                .addLine(
                                        "final ByteArrayOutputStream outStream = new ByteArrayOutputStream();");
                        getData()
                                .addLine(
                                        "BlancoXmlUtil.transformDom2Stream(document, outStream);");
                        getData().addLine("try {");
                        getData().addLine("outStream.flush();");
                        getData()
                                .addLine(
                                        "final String result = new String(outStream.toByteArray(), \"UTF-8\");");
                        getData()
                                .addLine(
                                        "final String pastEditorText = getDocumentProvider().getDocument(getEditorInput()).get();");
                        getData()
                                .addLine(
                                        "if (pastEditorText.equals(result) == false) {");
                        getData().addLine("// eقȂꍇɂ̂ݏ݂s܂B");
                        getData()
                                .addLine(
                                        "getDocumentProvider().getDocument(getEditorInput()).set(result);");
                        getData().addLine("}");
                        getData().addLine(
                                "} catch (UnsupportedEncodingException e) {");
                        getData().addLine("e.printStackTrace();");
                        getData().addLine("return;");
                        getData().addLine("} catch (IOException e) {");
                        getData().addLine("e.printStackTrace();");
                        getData().addLine("return;");
                        getData().addLine("}");
                    }
                });

                addMethod(new MethodExpander("saveToTextEditorInternal") {
                    protected Scope getScope() {
                        return Scope.PROTECTED;
                    }

                    protected boolean isAbstract() {
                        return true;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine("ۂɃf[^Z[u鏈eLq܂B");
                        setReturnType(new IgType("org.w3c.dom.Document"));
                    }

                    public void implement() {
                    }
                });
            }
        };
        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
