/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.service;

import java.io.File;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.service.valueobject.BlancoServiceStructure;

/**
 * T[ubg̃\[XR[h܂B
 * 
 * @author IGA Tosiki
 */
class BlancoServiceXml2SourceFileServlet {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    public void process(final BlancoServiceStructure argProcessStructure,
            final File argDirectoryTarget) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argProcessStructure
                .getPackage(), "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgClass = fCgFactory.createClass(argProcessStructure.getName(),
                "T[rX`ID[" + argProcessStructure.getName() + "]̃T[ubgNXB");
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.getExtendClassList().add(
                fCgFactory.createType("javax.servlet.http.HttpServlet"));
        if (BlancoStringUtil.null2Blank(argProcessStructure.getDescription())
                .length() > 0) {
            fCgClass.getLangDoc().getDescriptionList().add(
                    ":" + argProcessStructure.getDescription() + "<br>");
        }
        fCgClass.getLangDoc().getDescriptionList().add(
                "̃NX́AJavaŏꂽAvP[VAvP[VT[oɏ풓邽߂̎dg݂̈ꕔłB<br>");
        fCgClass
                .getLangDoc()
                .getDescriptionList()
                .add(
                        "̃NX̓T[ubgłBAvP[VT[őNɌĂяoT[ubgƂēo^邱Ƃɂď풓܂B<br>");
        fCgClass.getLangDoc().getDescriptionList().add("<br>");
        fCgClass
                .getLangDoc()
                .getDescriptionList()
                .add(
                        "AvP[VT[o web.xmlɉL̋Lqi܂͂ɑejLڂ邱ƂɂA풓邱Ƃł܂B<br>");
        fCgClass.getLangDoc().getDescriptionList().add("<pre>");
        fCgClass.getLangDoc().getDescriptionList().add(
                BlancoJavaSourceUtil.escapeStringAsJavaDoc("<servlet>"));
        fCgClass.getLangDoc().getDescriptionList().add(
                BlancoJavaSourceUtil.escapeStringAsJavaDoc("  <servlet-name>"
                        + argProcessStructure.getName() + "</servlet-name>"));
        fCgClass.getLangDoc().getDescriptionList().add(
                BlancoJavaSourceUtil.escapeStringAsJavaDoc("  <servlet-class>"
                        + argProcessStructure.getPackage() + "."
                        + argProcessStructure.getName() + "</servlet-class>"));
        fCgClass
                .getLangDoc()
                .getDescriptionList()
                .add(
                        BlancoJavaSourceUtil
                                .escapeStringAsJavaDoc("  <load-on-startup>1</load-on-startup>"));
        fCgClass.getLangDoc().getDescriptionList().add(
                BlancoJavaSourceUtil.escapeStringAsJavaDoc("</servlet>"));
        fCgClass.getLangDoc().getDescriptionList().add("</pre>");

        expandField(argProcessStructure);

        expandMethodInit(argProcessStructure);
        expandMethodDestory(argProcessStructure);

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * tB[hWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandField(final BlancoServiceStructure argProcessStructure) {

        {
            final BlancoCgField field = fCgFactory.createField("fLockObject",
                    "java.lang.Object", "Nǂ̃tOی삷邽߂̃~[ebNXIuWFNgB");
            fCgClass.getFieldList().add(field);

            field.setAccess("protected");
            field.setDefault("new Object()");
        }

        {
            final BlancoCgField field = fCgFactory.createField("fIsStarted",
                    "boolean", "̏풓NǂLtOB");
            fCgClass.getFieldList().add(field);

            field.setAccess("protected");
            field.setDefault("false");
        }

        {
            final BlancoCgField field = fCgFactory.createField("fProcess",
                    argProcessStructure.getPackage() + ".Abstract"
                            + argProcessStructure.getName() + "Process",
                    "̏풓̎ۂ̏NXB");
            fCgClass.getFieldList().add(field);

            field.setAccess("protected");
            field.setDefault("null");
        }
    }

    /**
     * init \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodInit(
            final BlancoServiceStructure argProcessStructure) {

        final BlancoCgMethod method = fCgFactory.createMethod("init",
                "T[rX̃Gg|CgB");
        fCgClass.getMethodList().add(method);

        method.getThrowList().add(
                fCgFactory.createException("javax.servlet.ServletException",
                        "T[ubgɊւOꍇB"));

        final List listLine = method.getLineList();

        listLine.add("synchronized (fLockObject) {");
        listLine.add("// IuWFNgɂ郍bNɂāAēh~Ă܂B");
        listLine.add("");
        listLine.add("System.out.println(\"" + argProcessStructure.getName()
                + ": init(): begin.\");");
        listLine.add("if (fIsStarted) {");
        listLine.add("System.out.println(\"" + argProcessStructure.getName()
                + ": init(): already started.\");");
        listLine.add("return;");
        listLine.add("}");
        listLine.add("");
        listLine.add("// NƂtOtrueɃZbg܂B");
        listLine
                .add("// ̃tOZbgŗOďfꂽƂĂA͂NԂłƂ݂Ȃ܂B");
        listLine.add("fIsStarted = true;");
        listLine.add("");
        if (BlancoStringUtil.null2Blank(argProcessStructure.getDescription())
                .length() > 0) {
            listLine.add("System.out.println(\""
                    + argProcessStructure.getName()
                    + ":["
                    + BlancoJavaSourceUtil
                            .escapeStringAsJavaSource(argProcessStructure
                                    .getDescription()) + "]\");");
        }
        listLine.add("");
        listLine.add("// ۂɏ풓NX̃CX^X쐬܂B");
        listLine.add("// |Cg");
        listLine.add("// L̍sŃRpCG[oꍇɂ́A܂ "
                + argProcessStructure.getName() + "Process 쐬ĂȂƂl܂B");
        listLine.add("// Abstract" + argProcessStructure.getName()
                + "Process NXp " + argProcessStructure.getPackage()
                + " pbP[W " + argProcessStructure.getName()
                + "Process NX쐬邱Ƃɂł邱ƂłB");
        listLine.add("fProcess = new " + argProcessStructure.getName()
                + "Process();");
        listLine.add("new Thread(fProcess).start();");
        listLine.add("");
        listLine.add("System.out.println(\"" + argProcessStructure.getName()
                + ": init(): end.\");");
        listLine.add("}");
    }

    /**
     * exit \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodDestory(
            final BlancoServiceStructure argProcessStructure) {

        final BlancoCgMethod method = fCgFactory.createMethod("destroy",
                "T[rX̔jʒmB");
        fCgClass.getMethodList().add(method);

        final List listLine = method.getLineList();

        listLine.add("synchronized (fLockObject) {");
        listLine.add("// IuWFNgɂ郍bNɂāAēh~Ă܂B");
        listLine.add("");
        listLine.add("System.out.println(\"" + argProcessStructure.getName()
                + ": destroy(): begin.\");");
        listLine.add("if (fIsStarted == false) {");
        listLine.add("System.out.println(\"" + argProcessStructure.getName()
                + ": destroy(): not started.\");");
        listLine.add("return;");
        listLine.add("}");
        listLine.add("");
        listLine.add("// NƂtOfalseɃZbg܂B");
        listLine.add("fIsStarted = false;");
        listLine.add("");
        listLine.add("");
        listLine.add("// Is܂B");
        listLine.add("fProcess.stop();");
        listLine.add("fProcess = null;");
        listLine.add("");
        listLine.add("System.out.println(\"" + argProcessStructure.getName()
                + ": destroy(): end.\");");
        listLine.add("}");
    }
}
