/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.service.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.service.BlancoServiceConstants;
import blanco.service.BlancoServiceMeta2Xml;
import blanco.service.BlancoServiceXml2SourceFile;
import blanco.service.resourcebundle.BlancoServiceResourceBundle;

/**
 * uT[rX`vExcell烁bZ[WNXE\[XR[h𐶐B
 * 
 * ̃NX́AApache Ant^XN܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoServiceTask extends AbstractBlancoServiceTask {
    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoServiceResourceBundle fBundle = new BlancoServiceResourceBundle();

    /**
     * `(XLS)\[XR[hApache Ant^XÑGg|CgłB
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoServiceConstants.PRODUCT_NAME + " ("
                + BlancoServiceConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fBundle
                        .getAnttaskErr001(getMetadir()));
            }

            // e|fBNg쐬B
            new File(getTmpdir() + BlancoServiceConstants.TARGET_SUBDIRECTORY)
                    .mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoServiceMeta2Xml().processDirectory(fileMetadir,
                    getTmpdir() + BlancoServiceConstants.TARGET_SUBDIRECTORY);

            // XMLꂽԃt@C\[XR[h𐶐
            final File[] fileMeta2 = new File(getTmpdir()
                    + BlancoServiceConstants.TARGET_SUBDIRECTORY).listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoServiceXml2SourceFile().process(fileMeta2[index],
                        new File(getTargetdir()));
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (TransformerException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }
}
