/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.definition;

import java.util.Iterator;

import blanco.db.conf.SelectQueryDotNet;

/**
 * @author Yasuo Nakanishi
 */
public class QueryIteratorDotNet {

    private SelectQueryDotNet _selectQuery = null;

    public QueryIteratorDotNet(final SelectQueryDotNet selectQuery) {
        _selectQuery = selectQuery;
    }

    public int getFieldCount() {
        return _selectQuery.getInParameterList().size();
    }

    public QueryFieldDotNet getField(final int index) {
        return (QueryFieldDotNet) _selectQuery.getInParameterList().get(index);
    }

    public Iterator getFieldIterator() {
        return _selectQuery.getFieldIterator();
    }

    public String getName() {
        return _selectQuery.getName();
    }

    public Iterator getInParameterIterator() {
        return _selectQuery.getInParameterIterator();
    }

    public String getQuery() {
        return _selectQuery.getQuery();
    }

    public void setQuery(final String query) {
        _selectQuery.setQuery(query);
    }

    public boolean isSingle() {
        return _selectQuery.isSingle();
    }
}